/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.Model;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventDispatcher;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEventDispatcher<M extends Model, D>
implements EventDispatcher<M, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessEventDispatcher.class);
    private final Set<String> correlationKeys;
    private final ProcessService processService;
    private final Optional<Function<D, M>> modelConverter;
    private final Process<M> process;
    private final ExecutorService executor;
    private final Function<DataEvent<D>, D> dataResolver;

    public ProcessEventDispatcher(Process<M> process, Optional<Function<D, M>> modelConverter, ProcessService processService, ExecutorService executor, Set<String> correlationKeys, Function<DataEvent<D>, D> dataResolver) {
        this.process = process;
        this.modelConverter = modelConverter;
        this.processService = processService;
        this.executor = executor;
        this.correlationKeys = correlationKeys;
        this.dataResolver = dataResolver;
    }

    public CompletableFuture<ProcessInstance<M>> dispatch(String trigger, DataEvent<D> event) {
        if (this.shouldSkipMessage(trigger, event)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Ignoring message for trigger {} in process {}. Skipping consumed message {}", new Object[]{trigger, this.process.id(), event});
            }
            return CompletableFuture.completedFuture(null);
        }
        return this.resolveCorrelationId(event).map(kogitoReferenceId -> this.asCompletable(trigger, event, this.findById((String)kogitoReferenceId))).orElseGet(() -> {
            String processInstanceId = event.getKogitoReferenceId();
            if (processInstanceId != null) {
                return this.asCompletable(trigger, event, this.findById(processInstanceId));
            }
            String businessKey = event.getKogitoBusinessKey();
            if (businessKey != null) {
                return this.asCompletable(trigger, event, this.findByBusinessKey(businessKey));
            }
            return CompletableFuture.supplyAsync(() -> this.startNewInstance(trigger, event), this.executor);
        });
    }

    private CompletableFuture<ProcessInstance<M>> asCompletable(String trigger, DataEvent<D> event, Optional<ProcessInstance<M>> processInstance) {
        return CompletableFuture.supplyAsync(() -> processInstance.map(pi -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending signal {} to process instance id '{}'", (Object)trigger, (Object)pi.id());
            }
            this.signalProcessInstance(trigger, pi.id(), event);
            return pi;
        }).orElseGet(() -> this.startNewInstance(trigger, event)), this.executor);
    }

    private Optional<ProcessInstance<M>> findById(String id) {
        LOGGER.debug("Received message with process instance id '{}'", (Object)id);
        Optional result = this.process.instances().findById(id);
        if (LOGGER.isDebugEnabled() && result.isEmpty()) {
            LOGGER.debug("No instance found for process instance id '{}'", (Object)id);
        }
        return result;
    }

    private Optional<ProcessInstance<M>> findByBusinessKey(String key) {
        LOGGER.debug("Received message with business key '{}'", (Object)key);
        Optional result = this.process.instances().findByBusinessKey(key);
        if (LOGGER.isDebugEnabled() && result.isEmpty()) {
            LOGGER.debug("No instance found for business key '{}'", (Object)key);
        }
        return result;
    }

    private Optional<CompositeCorrelation> compositeCorrelation(DataEvent<?> event) {
        return this.correlationKeys != null && !this.correlationKeys.isEmpty() ? Optional.of(new CompositeCorrelation(this.correlationKeys.stream().map(k -> new SimpleCorrelation(k, this.resolve(event, (String)k))).collect(Collectors.toSet()))) : Optional.empty();
    }

    private Optional<String> resolveCorrelationId(DataEvent<?> event) {
        return this.compositeCorrelation(event).flatMap(arg_0 -> ((CorrelationService)this.process.correlations()).find(arg_0)).map(CorrelationInstance::getCorrelatedId);
    }

    private Object resolve(DataEvent<?> event, String key) {
        if (event.getAttributeNames().contains(key)) {
            return event.getAttribute(key);
        }
        if (event.getExtensionNames().contains(key)) {
            return event.getExtension(key);
        }
        LOGGER.warn("Correlation key {} not found for event {}", (Object)key, event);
        return null;
    }

    private Optional<M> signalProcessInstance(String trigger, String id, DataEvent<D> event) {
        return this.processService.signalProcessInstance(this.process, id, this.dataResolver.apply(event), "Message-" + trigger);
    }

    private ProcessInstance<M> startNewInstance(String trigger, DataEvent<D> event) {
        return this.modelConverter.map(m -> {
            LOGGER.info("Starting new process instance with signal '{}'", (Object)trigger);
            return this.processService.createProcessInstance(this.process, event.getKogitoBusinessKey(), (Model)m.apply(this.dataResolver.apply(event)), this.headersFromEvent(event), event.getKogitoStartFromNode(), trigger, event.getKogitoProcessInstanceId(), (CompositeCorrelation)this.compositeCorrelation(event).orElse(null));
        }).orElseGet(() -> {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No matches found for trigger {} in process {}. Skipping consumed message {}", new Object[]{trigger, this.process.id(), event});
            }
            return null;
        });
    }

    protected Map<String, List<String>> headersFromEvent(DataEvent<D> event) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (String name : event.getAttributeNames()) {
            headers.put(name, this.toList(event.getAttribute(name)));
        }
        for (String name : event.getExtensionNames()) {
            headers.put(name, this.toList(event.getExtension(name)));
        }
        return headers;
    }

    private List<String> toList(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(Object::toString).collect(Collectors.toList());
        }
        return Arrays.asList(object.toString());
    }

    private boolean isEventTypeNotMatched(String trigger, DataEvent<?> event) {
        String eventType = event.getType();
        return eventType != null && !Objects.equals(trigger, eventType);
    }

    private boolean isSourceNotMatched(String trigger, DataEvent<?> event) {
        String source = event.getSource() == null ? null : event.getSource().toString();
        return source != null && !Objects.equals(event.getClass().getSimpleName(), source) && !Objects.equals(trigger, source);
    }

    private boolean shouldSkipMessage(String trigger, DataEvent<?> event) {
        return this.isEventTypeNotMatched(trigger, event) && this.isSourceNotMatched(trigger, event);
    }
}

