/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.kie.api.event.process.ErrorEvent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessMigrationEvent;
import org.kie.api.event.process.ProcessNodeEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.event.usertask.UserTaskAssignmentEvent;
import org.kie.api.event.usertask.UserTaskAttachmentEvent;
import org.kie.api.event.usertask.UserTaskCommentEvent;
import org.kie.api.event.usertask.UserTaskDeadlineEvent;
import org.kie.api.event.usertask.UserTaskStateEvent;
import org.kie.api.event.usertask.UserTaskVariableEvent;
import org.kie.kogito.Addons;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.process.ProcessInstanceErrorDataEvent;
import org.kie.kogito.event.process.ProcessInstanceErrorEventBody;
import org.kie.kogito.event.process.ProcessInstanceNodeDataEvent;
import org.kie.kogito.event.process.ProcessInstanceNodeEventBody;
import org.kie.kogito.event.process.ProcessInstanceSLADataEvent;
import org.kie.kogito.event.process.ProcessInstanceSLAEventBody;
import org.kie.kogito.event.process.ProcessInstanceStateDataEvent;
import org.kie.kogito.event.process.ProcessInstanceStateEventBody;
import org.kie.kogito.event.process.ProcessInstanceVariableDataEvent;
import org.kie.kogito.event.process.ProcessInstanceVariableEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAssignmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceAttachmentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceCommentEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceDeadlineEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceStateDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceStateEventBody;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableDataEvent;
import org.kie.kogito.event.usertask.UserTaskInstanceVariableEventBody;
import org.kie.kogito.internal.process.event.KogitoProcessVariableChangedEvent;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;

public class ProcessInstanceEventBatch
implements EventBatch {
    private String service;
    private Addons addons;
    Collection<DataEvent<?>> processedEvents;

    public ProcessInstanceEventBatch(String service, Addons addons) {
        this.service = service;
        this.addons = addons != null ? addons : Addons.EMTPY;
        this.processedEvents = new TreeSet(new Comparator<DataEvent<?>>(){

            @Override
            public int compare(DataEvent<?> event1, DataEvent<?> event2) {
                return event2 instanceof ProcessInstanceStateDataEvent && ((ProcessInstanceStateEventBody)((ProcessInstanceStateDataEvent)event2).getData()).getEventType() == 2 || event1 instanceof ProcessInstanceStateDataEvent && ((ProcessInstanceStateEventBody)((ProcessInstanceStateDataEvent)event1).getData()).getEventType() == 1 ? -1 : 1;
            }
        });
    }

    public void append(Object event) {
        if (event instanceof ProcessStartedEvent) {
            this.handleProcessStateEvent((ProcessStartedEvent)event);
        } else if (event instanceof ProcessCompletedEvent) {
            this.handleProcessStateEvent((ProcessCompletedEvent)event);
        } else if (event instanceof ProcessNodeTriggeredEvent) {
            this.handleProcessNodeEvent((ProcessNodeTriggeredEvent)event);
        } else if (event instanceof ProcessNodeLeftEvent) {
            this.handleProcessNodeEvent((ProcessNodeLeftEvent)event);
        } else if (event instanceof SLAViolatedEvent) {
            this.handleProcesssNodeEvent((SLAViolatedEvent)event);
        } else if (event instanceof ProcessVariableChangedEvent) {
            this.handleProcessVariableEvent((ProcessVariableChangedEvent)event);
        } else if (event instanceof ErrorEvent) {
            this.handleErrorEvent((ErrorEvent)event);
        } else if (event instanceof UserTaskStateEvent) {
            this.handleUserTaskStateEvent((UserTaskStateEvent)event);
        } else if (event instanceof UserTaskDeadlineEvent) {
            this.handleUserTaskDeadlineEvent((UserTaskDeadlineEvent)event);
        } else if (event instanceof UserTaskAssignmentEvent) {
            this.handleUserTaskAssignmentEvent((UserTaskAssignmentEvent)event);
        } else if (event instanceof UserTaskVariableEvent) {
            this.handleUserTaskVariableEvent((UserTaskVariableEvent)event);
        } else if (event instanceof UserTaskAttachmentEvent) {
            this.handleUserTaskAttachmentEvent((UserTaskAttachmentEvent)event);
        } else if (event instanceof UserTaskCommentEvent) {
            this.handleUserTaskCommentEvent((UserTaskCommentEvent)event);
        } else if (event instanceof ProcessMigrationEvent) {
            this.handleProcessStateEvent((ProcessMigrationEvent)event);
        }
    }

    public Collection<DataEvent<?>> events() {
        return this.processedEvents;
    }

    private void handleProcessVariableEvent(ProcessVariableChangedEvent event) {
        KogitoProcessVariableChangedEvent varEvent;
        if (event.getTags().contains("internal")) {
            return;
        }
        Map<String, Object> metadata = this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance());
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceVariableEventBody.Builder builder = ProcessInstanceVariableEventBody.create().eventDate(new Date()).eventUser(event.getEventIdentity()).processId(event.getProcessInstance().getProcessId()).processVersion(event.getProcessInstance().getProcessVersion()).processInstanceId(event.getProcessInstance().getId()).variableId(event.getVariableInstanceId()).variableName(event.getVariableId()).variableValue(event.getNewValue());
        if (event instanceof KogitoProcessVariableChangedEvent && (varEvent = (KogitoProcessVariableChangedEvent)event).getNodeInstance() != null && varEvent.getNodeInstance().getNodeInstanceContainer() != null && varEvent.getNodeInstance().getNodeInstanceContainer() instanceof KogitoNodeInstance) {
            builder.nodeContainerDefinitionId(((KogitoNodeInstance)varEvent.getNodeInstance().getNodeInstanceContainer()).getNodeDefinitionId());
            builder.nodeContainerInstanceId(((KogitoNodeInstance)varEvent.getNodeInstance().getNodeInstanceContainer()).getId());
        }
        ProcessInstanceVariableEventBody body = builder.build();
        ProcessInstanceVariableDataEvent piEvent = new ProcessInstanceVariableDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventIdentity(), metadata, body);
        piEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(piEvent);
    }

    private void handleProcesssNodeEvent(SLAViolatedEvent event) {
        Map<String, Object> metadata = this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance());
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceSLAEventBody.Builder builder = ProcessInstanceSLAEventBody.create().eventDate(Date.from(Instant.now())).eventUser(event.getEventIdentity()).processId(event.getProcessInstance().getProcessId()).processVersion(event.getProcessInstance().getProcessVersion()).processInstanceId(event.getProcessInstance().getId());
        if (event.getNodeInstance() instanceof KogitoNodeInstance) {
            KogitoNodeInstance ni = (KogitoNodeInstance)event.getNodeInstance();
            builder.nodeDefinitionId(ni.getNode().getUniqueId()).nodeInstanceId(ni.getId()).nodeName(ni.getNodeName()).nodeType(ni.getNode().getClass().getSimpleName()).slaDueDate(ni.getSlaDueDate());
        } else {
            builder.slaDueDate(pi.getSlaDueDate());
        }
        ProcessInstanceSLAEventBody body = builder.build();
        ProcessInstanceSLADataEvent piEvent = new ProcessInstanceSLADataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventIdentity(), metadata, body);
        piEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(piEvent);
    }

    private void handleProcessNodeEvent(ProcessNodeLeftEvent event) {
        KogitoNodeInstance nodeInstance = (KogitoNodeInstance)event.getNodeInstance();
        int eventType = 2;
        if (nodeInstance.getCancelType() != null) {
            switch (nodeInstance.getCancelType()) {
                case ABORTED: {
                    eventType = 3;
                    break;
                }
                case SKIPPED: {
                    eventType = 4;
                    break;
                }
                case OBSOLETE: {
                    eventType = 5;
                    break;
                }
                case ERROR: {
                    eventType = 6;
                }
            }
        }
        this.processedEvents.add(this.toProcessInstanceNodeEvent((ProcessNodeEvent)event, eventType));
    }

    private void handleProcessNodeEvent(ProcessNodeTriggeredEvent event) {
        this.processedEvents.add(this.toProcessInstanceNodeEvent((ProcessNodeEvent)event, 1));
    }

    private ProcessInstanceNodeDataEvent toProcessInstanceNodeEvent(ProcessNodeEvent event, int eventType) {
        KogitoWorkItem workItem;
        Map<String, Object> metadata = this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance());
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        KogitoNodeInstance nodeInstance = (KogitoNodeInstance)event.getNodeInstance();
        ProcessInstanceNodeEventBody.Builder builder = ProcessInstanceNodeEventBody.create().eventDate(new Date()).eventUser(event.getEventIdentity()).eventType(Integer.valueOf(eventType)).processId(event.getProcessInstance().getProcessId()).processVersion(event.getProcessInstance().getProcessVersion()).processInstanceId(event.getProcessInstance().getId()).nodeName(event.getNodeInstance().getNodeName()).nodeType(event.getNodeInstance().getNode().getClass().getSimpleName()).nodeInstanceId(event.getNodeInstance().getId()).nodeDefinitionId(event.getNodeInstance().getNode().getUniqueId()).slaDueDate(nodeInstance.getSlaDueDate());
        if (eventType == 1) {
            builder.connectionNodeDefinitionId((String)nodeInstance.getMetaData().get("IncomingConnection"));
        } else {
            builder.connectionNodeDefinitionId((String)nodeInstance.getMetaData().get("OutgoingConnection"));
        }
        if (nodeInstance instanceof KogitoWorkItemNodeInstance && (workItem = ((KogitoWorkItemNodeInstance)nodeInstance).getWorkItem()) != null) {
            builder.workItemId(workItem.getStringId());
        }
        ProcessInstanceNodeEventBody body = builder.build();
        ProcessInstanceNodeDataEvent piEvent = new ProcessInstanceNodeDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventIdentity(), metadata, body);
        piEvent.setKogitoBusinessKey(pi.getBusinessKey());
        return piEvent;
    }

    private void handleErrorEvent(ErrorEvent event) {
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceErrorEventBody errorBody = ProcessInstanceErrorEventBody.create().eventDate(new Date()).eventUser(event.getEventIdentity()).processInstanceId(pi.getId()).processId(pi.getProcessId()).processVersion(pi.getProcessVersion()).nodeDefinitionId(pi.getNodeIdInError()).nodeInstanceId(pi.getNodeInstanceIdInError()).errorMessage(pi.getErrorMessage()).build();
        Map<String, Object> metadata = this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance());
        ProcessInstanceErrorDataEvent piEvent = new ProcessInstanceErrorDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventIdentity(), metadata, errorBody);
        piEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(piEvent);
    }

    private void handleProcessStateEvent(ProcessCompletedEvent event) {
        this.processedEvents.add(this.toProcessInstanceStateEvent((ProcessEvent)event, 2));
    }

    private void handleProcessStateEvent(ProcessStartedEvent event) {
        this.processedEvents.add(this.toProcessInstanceStateEvent((ProcessEvent)event, 1));
    }

    private void handleProcessStateEvent(ProcessMigrationEvent event) {
        this.processedEvents.add(this.toProcessInstanceStateEvent((ProcessEvent)event, 3));
    }

    private ProcessInstanceStateDataEvent toProcessInstanceStateEvent(ProcessEvent event, int eventType) {
        Map<String, Object> metadata = this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance());
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        ProcessInstanceStateEventBody.Builder builder = ProcessInstanceStateEventBody.create().eventDate(new Date()).eventUser(event.getEventIdentity()).eventType(Integer.valueOf(eventType)).processId(event.getProcessInstance().getProcessId()).processVersion(event.getProcessInstance().getProcessVersion()).processInstanceId(event.getProcessInstance().getId()).processName(event.getProcessInstance().getProcessName()).processVersion(event.getProcessInstance().getProcessVersion()).processType(event.getProcessInstance().getProcess().getType()).parentInstanceId(pi.getParentProcessInstanceId()).rootProcessId(pi.getRootProcessId()).rootProcessInstanceId(pi.getRootProcessInstanceId()).state(Integer.valueOf(event.getProcessInstance().getState())).businessKey(pi.getBusinessKey()).slaDueDate(pi.getSlaDueDate());
        String securityRoles = (String)event.getProcessInstance().getProcess().getMetaData().get("securityRoles");
        if (securityRoles != null) {
            builder.roles(securityRoles.split(","));
        }
        ProcessInstanceStateEventBody body = builder.build();
        ProcessInstanceStateDataEvent piEvent = new ProcessInstanceStateDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventIdentity(), metadata, body);
        piEvent.setKogitoBusinessKey(pi.getBusinessKey());
        return piEvent;
    }

    private Map<String, Object> buildProcessMetadata(KogitoWorkflowProcessInstance pi) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.processinstance.id", pi.getId());
        metadata.put("kogito.process.version", pi.getProcessVersion());
        metadata.put("kogito.process.id", pi.getProcessId());
        metadata.put("kogito.processinstance.state", String.valueOf(pi.getState()));
        metadata.put("kogito.process.type", pi.getProcess().getType());
        metadata.put("kogito.processinstance.parentInstanceId", pi.getParentProcessInstanceId());
        metadata.put("kogito.processinstance.rootProcessId", pi.getRootProcessId());
        metadata.put("kogito.processinstance.rootInstanceId", pi.getRootProcessInstanceId());
        return metadata;
    }

    private void handleUserTaskCommentEvent(UserTaskCommentEvent event) {
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        int eventType = 1;
        if (event.getOldComment() != null && event.getNewComment() == null) {
            eventType = 3;
        } else if (event.getOldComment() != null && event.getNewComment() != null) {
            eventType = 2;
        }
        UserTaskInstanceCommentEventBody.Builder builder = UserTaskInstanceCommentEventBody.create().eventType(eventType).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName());
        String updatedBy = null;
        switch (eventType) {
            case 1: 
            case 2: {
                builder.commentContent(event.getNewComment().getCommentContent()).commentId(event.getNewComment().getCommentId()).eventDate(event.getNewComment().getUpdatedAt()).eventUser(event.getNewComment().getUpdatedBy());
                updatedBy = event.getNewComment().getUpdatedBy();
                break;
            }
            case 3: {
                builder.commentId(event.getOldComment().getCommentId()).eventDate(event.getOldComment().getUpdatedAt()).eventUser(event.getOldComment().getUpdatedBy());
                updatedBy = event.getOldComment().getUpdatedBy();
            }
        }
        UserTaskInstanceCommentEventBody body = builder.build();
        UserTaskInstanceCommentDataEvent utEvent = new UserTaskInstanceCommentDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), updatedBy, metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private void handleUserTaskAttachmentEvent(UserTaskAttachmentEvent event) {
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        int eventType = 1;
        if (event.getOldAttachment() != null && event.getNewAttachment() == null) {
            eventType = 3;
        } else if (event.getOldAttachment() != null && event.getNewAttachment() != null) {
            eventType = 2;
        }
        UserTaskInstanceAttachmentEventBody.Builder builder = UserTaskInstanceAttachmentEventBody.create().eventType(eventType).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName());
        String updatedBy = null;
        switch (eventType) {
            case 1: 
            case 2: {
                builder.attachmentName(event.getNewAttachment().getAttachmentName()).attachmentId(event.getNewAttachment().getAttachmentId()).attachmentURI(event.getNewAttachment().getAttachmentURI()).eventDate(event.getNewAttachment().getUpdatedAt()).eventUser(event.getNewAttachment().getUpdatedBy());
                updatedBy = event.getNewAttachment().getUpdatedBy();
                break;
            }
            case 3: {
                builder.attachmentId(event.getOldAttachment().getAttachmentId()).eventDate(event.getOldAttachment().getUpdatedAt()).eventUser(event.getOldAttachment().getUpdatedBy());
                updatedBy = event.getOldAttachment().getUpdatedBy();
            }
        }
        UserTaskInstanceAttachmentEventBody body = builder.build();
        UserTaskInstanceAttachmentDataEvent utEvent = new UserTaskInstanceAttachmentDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), updatedBy, metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private void handleUserTaskAssignmentEvent(UserTaskAssignmentEvent event) {
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        UserTaskInstanceAssignmentEventBody.Builder builder = UserTaskInstanceAssignmentEventBody.create().eventDate(new Date()).eventUser(event.getEventUser()).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName()).assignmentType(event.getAssignmentType()).users(event.getNewUsersId());
        UserTaskInstanceAssignmentEventBody body = builder.build();
        UserTaskInstanceAssignmentDataEvent utEvent = new UserTaskInstanceAssignmentDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventUser(), metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private void handleUserTaskDeadlineEvent(UserTaskDeadlineEvent event) {
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        UserTaskInstanceDeadlineEventBody.Builder builder = UserTaskInstanceDeadlineEventBody.create().eventDate(new Date()).eventUser(event.getEventUser()).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName()).notification(event.getNotification());
        UserTaskInstanceDeadlineEventBody body = builder.build();
        UserTaskInstanceDeadlineDataEvent utEvent = new UserTaskInstanceDeadlineDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventUser(), metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private void handleUserTaskStateEvent(UserTaskStateEvent event) {
        if (event.getNewStatus() == null) {
            return;
        }
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        UserTaskInstanceStateEventBody.Builder builder = UserTaskInstanceStateEventBody.create().eventDate(new Date()).eventUser(event.getEventUser()).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName()).userTaskDescription(((HumanTaskWorkItem)event.getWorkItem()).getTaskDescription()).userTaskPriority(((HumanTaskWorkItem)event.getWorkItem()).getTaskPriority()).userTaskReferenceName(((HumanTaskWorkItem)event.getWorkItem()).getReferenceName()).state(event.getNewStatus()).actualOwner(((HumanTaskWorkItem)event.getWorkItem()).getActualOwner()).eventType(this.isTransition(event) ? event.getNewStatus() : "Modify").processInstanceId(event.getProcessInstance().getId());
        UserTaskInstanceStateEventBody body = builder.build();
        UserTaskInstanceStateDataEvent utEvent = new UserTaskInstanceStateDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventUser(), metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private boolean isTransition(UserTaskStateEvent event) {
        return !Objects.equals(event.getOldStatus(), event.getNewStatus());
    }

    private void handleUserTaskVariableEvent(UserTaskVariableEvent event) {
        Map<String, Object> metadata = this.buildUserTaskMetadata((HumanTaskWorkItem)event.getWorkItem());
        metadata.putAll(this.buildProcessMetadata((KogitoWorkflowProcessInstance)event.getProcessInstance()));
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)event.getProcessInstance();
        UserTaskInstanceVariableEventBody.Builder builder = UserTaskInstanceVariableEventBody.create().eventDate(new Date()).eventUser(event.getEventUser()).userTaskDefinitionId(event.getUserTaskDefinitionId()).userTaskInstanceId(((HumanTaskWorkItem)event.getWorkItem()).getStringId()).userTaskName(((HumanTaskWorkItem)event.getWorkItem()).getTaskName()).variableId(event.getVariableName()).variableName(event.getVariableName()).variableValue(event.getNewValue()).variableType(event.getVariableType().name());
        UserTaskInstanceVariableEventBody body = builder.build();
        UserTaskInstanceVariableDataEvent utEvent = new UserTaskInstanceVariableDataEvent(this.buildSource(event.getProcessInstance().getProcessId()), this.addons.toString(), event.getEventUser(), metadata, body);
        utEvent.setKogitoBusinessKey(pi.getBusinessKey());
        this.processedEvents.add(utEvent);
    }

    private Map<String, Object> buildUserTaskMetadata(HumanTaskWorkItem pi) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("kogito.usertaskinstance.id", pi.getStringId());
        metadata.put("kogito.usertaskinstance.referenceId", pi.getReferenceName());
        metadata.put("kogito.usertaskinstance.state", pi.getPhaseStatus());
        return metadata;
    }

    protected String extractRuntimeSource(Map<String, String> metadata) {
        return this.buildSource(metadata.get("kogito.process.id"));
    }

    private String buildSource(String processId) {
        if (processId == null) {
            return null;
        }
        return this.service + "/" + (processId.contains(".") ? processId.substring(processId.lastIndexOf(46) + 1) : processId);
    }
}

