/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class ProtobufBooleanMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Boolean.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(BoolValue.class);
    }

    @Override
    public Any marshall(Object unmarshalled) {
        return Any.pack((Message)BoolValue.of((boolean)((Boolean)unmarshalled)));
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            BoolValue storedValue = (BoolValue)data.unpack(BoolValue.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a boolean value", e1);
        }
    }
}

