/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class ProtobufIntegerMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Integer.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(Int32Value.class);
    }

    @Override
    public Any marshall(Object unmarshalled) {
        return Any.pack((Message)Int32Value.of((int)((Integer)unmarshalled)));
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            Int32Value storedValue = (Int32Value)data.unpack(Int32Value.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a int value", e1);
        }
    }
}

