/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers;

import com.google.protobuf.Any;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import org.jbpm.flow.serialization.ObjectMarshallerStrategy;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class ProtobufLongMarshallerStrategy
implements ObjectMarshallerStrategy {
    @Override
    public boolean acceptForMarshalling(Object value) {
        return Long.class.equals(value.getClass());
    }

    @Override
    public boolean acceptForUnmarshalling(Any value) {
        return value.is(Int64Value.class);
    }

    @Override
    public Any marshall(Object unmarshalled) {
        return Any.pack((Message)Int64Value.of((long)((Long)unmarshalled)));
    }

    @Override
    public Object unmarshall(Any data) {
        try {
            Int64Value storedValue = (Int64Value)data.unpack(Int64Value.class);
            return storedValue.getValue();
        }
        catch (InvalidProtocolBufferException e1) {
            throw new ProcessInstanceMarshallerException("Error trying to unmarshalling a long value", e1);
        }
    }
}

