/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.impl.marshallers.state;

import com.google.protobuf.Any;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.flow.serialization.MarshallerWriterContext;
import org.jbpm.flow.serialization.NodeInstanceWriter;
import org.jbpm.flow.serialization.impl.ProtobufVariableWriter;
import org.jbpm.flow.serialization.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.jbpm.flow.serialization.protobuf.KogitoWorkItemsProtobuf;
import org.jbpm.process.instance.impl.humantask.Reassignment;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.HumanTaskWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;

public class WorkItemNodeInstanceWriter
implements NodeInstanceWriter {
    @Override
    public boolean accept(NodeInstance value) {
        return value instanceof WorkItemNodeInstance;
    }

    @Override
    public GeneratedMessageV3.Builder<?> write(MarshallerWriterContext context, NodeInstance value) {
        ProtobufVariableWriter varWriter = new ProtobufVariableWriter(context);
        WorkItemNodeInstance nodeInstance = (WorkItemNodeInstance)value;
        KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.Builder builder = KogitoNodeInstanceContentsProtobuf.WorkItemNodeInstanceContent.newBuilder();
        List timerInstances = nodeInstance.getTimerInstances();
        if (timerInstances != null) {
            builder.addAllTimerInstanceId(timerInstances);
        }
        if (nodeInstance.getTimerInstancesReference() != null) {
            builder.putAllTimerInstanceReference(nodeInstance.getTimerInstancesReference());
        }
        if (nodeInstance.getExceptionHandlingProcessInstanceId() != null) {
            builder.setErrorHandlingProcessInstanceId(nodeInstance.getExceptionHandlingProcessInstanceId());
        }
        InternalKogitoWorkItem workItem = nodeInstance.getWorkItem();
        builder.setWorkItemId(nodeInstance.getWorkItemId()).setName(workItem.getName()).setState(workItem.getState()).setPhaseId(workItem.getPhaseId()).setPhaseStatus(workItem.getPhaseStatus()).setStartDate(workItem.getStartDate().getTime()).addAllVariable(varWriter.buildVariables(new ArrayList<Map.Entry<String, Object>>(workItem.getParameters().entrySet()))).addAllResult(varWriter.buildVariables(new ArrayList<Map.Entry<String, Object>>(workItem.getResults().entrySet())));
        if (workItem.getCompleteDate() != null) {
            builder.setCompleteDate(workItem.getCompleteDate().getTime());
        }
        if (nodeInstance instanceof HumanTaskNodeInstance) {
            builder.setWorkItemData(Any.pack((Message)this.buildHumanTaskWorkItemData((HumanTaskNodeInstance)nodeInstance, (HumanTaskWorkItem)nodeInstance.getWorkItem())));
        }
        return builder;
    }

    private KogitoWorkItemsProtobuf.HumanTaskWorkItemData buildHumanTaskWorkItemData(HumanTaskNodeInstance nodeInstance, HumanTaskWorkItem workItem) {
        KogitoWorkItemsProtobuf.HumanTaskWorkItemData.Builder builder = KogitoWorkItemsProtobuf.HumanTaskWorkItemData.newBuilder();
        if (workItem.getTaskPriority() != null) {
            builder.setTaskPriority(workItem.getTaskPriority());
        }
        if (workItem.getReferenceName() != null) {
            builder.setTaskReferenceName(workItem.getReferenceName());
        }
        if (workItem.getTaskDescription() != null) {
            builder.setTaskDescription(workItem.getTaskDescription());
        }
        if (workItem.getActualOwner() != null) {
            builder.setActualOwner(workItem.getActualOwner());
        }
        if (workItem.getTaskName() != null) {
            builder.setTaskName(workItem.getTaskName());
        }
        if (workItem.getPotentialUsers() != null) {
            builder.addAllPotUsers(workItem.getPotentialUsers());
        }
        if (workItem.getPotentialGroups() != null) {
            builder.addAllPotGroups(workItem.getPotentialGroups());
        }
        if (workItem.getExcludedUsers() != null) {
            builder.addAllExcludedUsers(workItem.getExcludedUsers());
        }
        if (workItem.getAdminUsers() != null) {
            builder.addAllAdminUsers(workItem.getAdminUsers());
        }
        if (workItem.getAdminGroups() != null) {
            builder.addAllAdminGroups(workItem.getAdminGroups());
        }
        if (workItem.getComments() != null) {
            builder.addAllComments(this.buildComments(workItem.getComments().values()));
        }
        if (workItem.getAttachments() != null) {
            builder.addAllAttachments(this.buildAttachments(workItem.getAttachments().values()));
        }
        if (nodeInstance.getNotStartedDeadlineTimers() != null) {
            builder.putAllStartDeadlines(this.buildDeadlines(nodeInstance.getNotStartedDeadlineTimers()));
        }
        if (nodeInstance.getNotStartedReassignments() != null) {
            builder.putAllStartReassigments(this.buildReassignments(nodeInstance.getNotStartedReassignments()));
        }
        if (nodeInstance.getNotCompletedDeadlineTimers() != null) {
            builder.putAllCompletedDeadlines(this.buildDeadlines(nodeInstance.getNotCompletedDeadlineTimers()));
        }
        if (nodeInstance.getNotCompletedReassigments() != null) {
            builder.putAllCompletedReassigments(this.buildReassignments(nodeInstance.getNotCompletedReassigments()));
        }
        return builder.build();
    }

    private List<KogitoWorkItemsProtobuf.Comment> buildComments(Iterable<Comment> comments) {
        ArrayList<KogitoWorkItemsProtobuf.Comment> commentsProtobuf = new ArrayList<KogitoWorkItemsProtobuf.Comment>();
        for (Comment comment : comments) {
            KogitoWorkItemsProtobuf.Comment workItemComment = KogitoWorkItemsProtobuf.Comment.newBuilder().setId(((String)((Object)comment.getId())).toString()).setContent((String)((Object)comment.getContent())).setUpdatedBy(comment.getUpdatedBy()).setUpdatedAt(comment.getUpdatedAt().getTime()).build();
            commentsProtobuf.add(workItemComment);
        }
        return commentsProtobuf;
    }

    private List<KogitoWorkItemsProtobuf.Attachment> buildAttachments(Iterable<Attachment> attachments) {
        ArrayList<KogitoWorkItemsProtobuf.Attachment> attachmentProtobuf = new ArrayList<KogitoWorkItemsProtobuf.Attachment>();
        for (Attachment attachment : attachments) {
            KogitoWorkItemsProtobuf.Attachment workItemAttachment = KogitoWorkItemsProtobuf.Attachment.newBuilder().setId(((String)((Object)attachment.getId())).toString()).setContent(((URI)attachment.getContent()).toString()).setUpdatedBy(attachment.getUpdatedBy()).setUpdatedAt(attachment.getUpdatedAt().getTime()).setName(attachment.getName()).build();
            attachmentProtobuf.add(workItemAttachment);
        }
        return attachmentProtobuf;
    }

    private Map<String, KogitoWorkItemsProtobuf.Deadline> buildDeadlines(Map<String, Map<String, Object>> deadlines) {
        HashMap<String, KogitoWorkItemsProtobuf.Deadline> deadlinesProtobuf = new HashMap<String, KogitoWorkItemsProtobuf.Deadline>();
        for (Map.Entry<String, Map<String, Object>> entry : deadlines.entrySet()) {
            KogitoWorkItemsProtobuf.Deadline.Builder builder = KogitoWorkItemsProtobuf.Deadline.newBuilder();
            entry.getValue().forEach((k, v) -> builder.putContent((String)k, v.toString()));
            deadlinesProtobuf.put(entry.getKey(), builder.build());
        }
        return deadlinesProtobuf;
    }

    private Map<String, KogitoWorkItemsProtobuf.Reassignment> buildReassignments(Map<String, Reassignment> reassignments) {
        HashMap<String, KogitoWorkItemsProtobuf.Reassignment> reassignmentsProtobuf = new HashMap<String, KogitoWorkItemsProtobuf.Reassignment>();
        for (Map.Entry<String, Reassignment> entry : reassignments.entrySet()) {
            KogitoWorkItemsProtobuf.Reassignment.Builder builder = KogitoWorkItemsProtobuf.Reassignment.newBuilder();
            builder.addAllGroups(entry.getValue().getPotentialGroups());
            builder.addAllUsers(entry.getValue().getPotentialUsers());
            reassignmentsProtobuf.put(entry.getKey(), builder.build());
        }
        return reassignmentsProtobuf;
    }
}

