/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.serialization.marshaller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.infinispan.protostream.MessageMarshaller;
import org.jbpm.flow.serialization.ProcessInstanceMarshallerException;

public class SerializableProtostreamBaseMarshaller
implements MessageMarshaller<Serializable> {
    public Class<? extends Serializable> getJavaClass() {
        return Serializable.class;
    }

    public String getTypeName() {
        return "kogito.Serializable";
    }

    public Serializable readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        return (Serializable)this.readObject(reader.readBytes("data"));
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Serializable serializable) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(stream);){
            out.writeObject(serializable);
            writer.writeBytes("data", stream.toByteArray());
        }
        catch (IOException e) {
            throw new ProcessInstanceMarshallerException("Not possible to marshall value: " + serializable, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object readObject(byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(is);){
                object = ois.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ProcessInstanceMarshallerException("Unexpected error while trying to unmarshall object", e);
        }
    }
}

