/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.v1_3;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.Artifact;
import org.kie.dmn.model.api.BusinessContextElement;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.DecisionService;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.ElementCollection;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.dmndi.DMNDI;
import org.kie.dmn.model.v1_3.TNamedElement;

public class TDefinitions
extends TNamedElement
implements Definitions {
    public static final String DEFAULT_EXPRESSION_LANGUAGE = "https://www.omg.org/spec/DMN/20191111/FEEL/";
    public static final String DEFAULT_TYPE_LANGUAGE = "https://www.omg.org/spec/DMN/20191111/FEEL/";
    protected List<Import> _import;
    protected List<ItemDefinition> itemDefinition;
    protected List<DRGElement> drgElement;
    protected List<Artifact> artifact;
    protected List<ElementCollection> elementCollection;
    protected List<BusinessContextElement> businessContextElement;
    protected DMNDI dmndi;
    protected String expressionLanguage;
    protected String typeLanguage;
    protected String namespace;
    protected String exporter;
    protected String exporterVersion;

    @Override
    public List<Import> getImport() {
        if (this._import == null) {
            this._import = new ArrayList<Import>();
        }
        return this._import;
    }

    @Override
    public List<ItemDefinition> getItemDefinition() {
        if (this.itemDefinition == null) {
            this.itemDefinition = new ArrayList<ItemDefinition>();
        }
        return this.itemDefinition;
    }

    @Override
    public List<DRGElement> getDrgElement() {
        if (this.drgElement == null) {
            this.drgElement = new ArrayList<DRGElement>();
        }
        return this.drgElement;
    }

    @Override
    public List<Artifact> getArtifact() {
        if (this.artifact == null) {
            this.artifact = new ArrayList<Artifact>();
        }
        return this.artifact;
    }

    @Override
    public List<ElementCollection> getElementCollection() {
        if (this.elementCollection == null) {
            this.elementCollection = new ArrayList<ElementCollection>();
        }
        return this.elementCollection;
    }

    @Override
    public List<BusinessContextElement> getBusinessContextElement() {
        if (this.businessContextElement == null) {
            this.businessContextElement = new ArrayList<BusinessContextElement>();
        }
        return this.businessContextElement;
    }

    @Override
    public DMNDI getDMNDI() {
        return this.dmndi;
    }

    @Override
    public void setDMNDI(DMNDI value) {
        this.dmndi = value;
    }

    @Override
    public String getExpressionLanguage() {
        if (this.expressionLanguage == null) {
            return "https://www.omg.org/spec/DMN/20191111/FEEL/";
        }
        return this.expressionLanguage;
    }

    @Override
    public String getTypeLanguage() {
        if (this.typeLanguage == null) {
            return "https://www.omg.org/spec/DMN/20191111/FEEL/";
        }
        return this.typeLanguage;
    }

    @Override
    public void setExpressionLanguage(String value) {
        this.expressionLanguage = value;
    }

    @Override
    public void setTypeLanguage(String value) {
        this.typeLanguage = value;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String value) {
        this.namespace = value;
    }

    @Override
    public String getExporter() {
        return this.exporter;
    }

    @Override
    public void setExporter(String value) {
        this.exporter = value;
    }

    @Override
    public String getExporterVersion() {
        return this.exporterVersion;
    }

    @Override
    public void setExporterVersion(String value) {
        this.exporterVersion = value;
    }

    @Override
    public List<DecisionService> getDecisionService() {
        return this.drgElement.stream().filter(DecisionService.class::isInstance).map(DecisionService.class::cast).collect(Collectors.toList());
    }

    @Override
    public void normalize() {
        for (ItemDefinition itemDefinition : this.getItemDefinition()) {
            TDefinitions.processQNameURIs(itemDefinition);
        }
    }

    private static void processQNameURIs(ItemDefinition iDef) {
        QName typeRef = iDef.getTypeRef();
        if (typeRef != null && "".equals(typeRef.getNamespaceURI())) {
            String namespace = iDef.getNamespaceURI(typeRef.getPrefix());
            iDef.setTypeRef(new QName(namespace, typeRef.getLocalPart(), typeRef.getPrefix()));
        }
        for (ItemDefinition comp : iDef.getItemComponent()) {
            TDefinitions.processQNameURIs(comp);
        }
    }
}

