/*
 * Decompiled with CFR 0.152.
 */
package org.drools.codegen.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.util.Config;

public class GeneratedFileWriter {
    private final Path classesDir;
    private final Path resourcePath;
    private final Path scaffoldedSourcesDir;

    public static Builder builder(String finalPath, String resourcesDirectoryProperty, String sourcesDirectoryProperty) {
        return GeneratedFileWriter.builder(finalPath, resourcesDirectoryProperty, sourcesDirectoryProperty, AppPaths.BT);
    }

    static Builder builder(String finalPath, String resourcesDirectoryProperty, String sourcesDirectoryProperty, AppPaths.BuildTool bt) {
        String targetClasses = bt.CLASSES_PATH.toString();
        String generatedResourcesSourcesKogito = Path.of(bt.GENERATED_RESOURCES_PATH.toString(), finalPath).toString();
        String generatedSourcesKogito = Path.of(bt.GENERATED_SOURCES_PATH.toString(), finalPath).toString();
        return new Builder(targetClasses, Config.getConfig((String)resourcesDirectoryProperty, (String)generatedResourcesSourcesKogito), Config.getConfig((String)sourcesDirectoryProperty, (String)generatedSourcesKogito));
    }

    GeneratedFileWriter(Path classesDir, Path resourcePath, Path scaffoldedSourcesDir) {
        this.classesDir = classesDir;
        this.resourcePath = resourcePath;
        this.scaffoldedSourcesDir = scaffoldedSourcesDir;
    }

    public void writeAll(Collection<GeneratedFile> generatedFiles) {
        generatedFiles.forEach(this::write);
    }

    public void write(GeneratedFile f) throws UncheckedIOException {
        try {
            GeneratedFileType.Category category = f.category();
            switch (category) {
                case INTERNAL_RESOURCE: 
                case STATIC_HTTP_RESOURCE: 
                case COMPILED_CLASS: {
                    this.writeGeneratedFile(f, this.classesDir);
                    break;
                }
                case SOURCE: {
                    this.writeGeneratedFile(f, this.scaffoldedSourcesDir);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Category " + category.name());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Path getClassesDir() {
        return this.classesDir;
    }

    public Path getResourcePath() {
        return this.resourcePath;
    }

    public Path getScaffoldedSourcesDir() {
        return this.scaffoldedSourcesDir;
    }

    void writeGeneratedFile(GeneratedFile f, Path location) throws IOException {
        if (location == null) {
            return;
        }
        Files.write(this.pathOf(location, f.path()), f.contents(), new OpenOption[0]);
    }

    private Path pathOf(Path location, Path end) throws IOException {
        Path path = location.resolve(end);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return path;
    }

    public static class Builder {
        final String classesDir;
        final String resourcePath;
        final String scaffoldedSourcesDir;

        private Builder(String classesDir, String resourcesDir, String scaffoldedSourcesDir) {
            this.classesDir = classesDir;
            this.resourcePath = resourcesDir;
            this.scaffoldedSourcesDir = scaffoldedSourcesDir;
        }

        public GeneratedFileWriter build(Path basePath) {
            return new GeneratedFileWriter(basePath.resolve(this.classesDir), basePath.resolve(this.resourcePath), basePath.resolve(this.scaffoldedSourcesDir));
        }
    }
}

