/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.openapi.DMNOASGenerator;
import org.kie.dmn.openapi.NamingPolicy;
import org.kie.dmn.openapi.impl.DMNTypeSchemas;
import org.kie.dmn.openapi.impl.DefaultNamingPolicy;
import org.kie.dmn.openapi.impl.NamespaceAwareNamingPolicy;
import org.kie.dmn.openapi.model.DMNModelIOSets;
import org.kie.dmn.openapi.model.DMNOASResult;
import org.kie.dmn.typesafe.DMNTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNOASGeneratorImpl
implements DMNOASGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DMNOASGeneratorImpl.class);
    private final List<DMNModel> dmnModels;
    private final List<DMNModelIOSets> ioSets = new ArrayList<DMNModelIOSets>();
    private final Set<DMNType> typesIndex = new HashSet<DMNType>();
    private final String refPrefix;
    private NamingPolicy namingPolicy;
    private final Map<DMNType, Schema> schemas = new HashMap<DMNType, Schema>();
    private ObjectNode jsonSchema;

    public DMNOASGeneratorImpl(Collection<DMNModel> models, String refPrefix) {
        this.dmnModels = new ArrayList<DMNModel>(models);
        this.refPrefix = refPrefix;
    }

    @Override
    public DMNOASResult build() {
        this.indexModels();
        this.assignNamesToIOSets();
        this.determineNamingPolicy();
        this.schemas.putAll(new DMNTypeSchemas(this.ioSets, this.typesIndex, this.namingPolicy).generateSchemas());
        this.prepareSerializaton();
        return new DMNOASResult(this.jsonSchema, this.ioSets, this.schemas, this.namingPolicy);
    }

    private void indexModels() {
        for (DMNModel model : this.dmnModels) {
            DMNModelIOSets s = new DMNModelIOSets(model);
            this.ioSets.add(s);
            this.visitForIndexing(s);
        }
    }

    private void prepareSerializaton() {
        ObjectNode tree = JsonUtil.objectNode();
        ObjectNode definitions = JsonUtil.objectNode();
        tree.set("definitions", (JsonNode)definitions);
        List sortedEntries = this.schemas.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(DMNType::getName))).toList();
        for (Map.Entry kv : sortedEntries) {
            SchemaWriter.writeSchema((ObjectNode)definitions, (Schema)((Schema)kv.getValue()), (String)this.namingPolicy.getName(kv.getKey()));
        }
        this.jsonSchema = tree;
    }

    private void determineNamingPolicy() {
        this.namingPolicy = new DefaultNamingPolicy(this.refPrefix);
        if (this.namingIntegrityCheck()) {
            return;
        }
        this.namingPolicy = new NamespaceAwareNamingPolicy(this.dmnModels, this.refPrefix);
        if (this.namingIntegrityCheck()) {
            return;
        }
        this.reportCollisions();
    }

    private void reportCollisions() {
        ArrayList<String> messages = new ArrayList<String>();
        Map<String, Long> countByName = this.typesIndex.stream().collect(Collectors.groupingBy(this.namingPolicy::getName, Collectors.counting()));
        for (Map.Entry<String, Long> kv : countByName.entrySet()) {
            if (kv.getValue() <= 1L) continue;
            List collidingOverName = this.typesIndex.stream().filter(t -> this.namingPolicy.getName((DMNType)t).equals(kv.getKey())).collect(Collectors.toList());
            List fromModels = this.dmnModels.stream().filter(m -> m.getItemDefinitions().stream().anyMatch(itemDef -> collidingOverName.contains(itemDef.getType()))).collect(Collectors.toList());
            String modelsCoords = fromModels.stream().map(m -> String.format("Model '%s' (namespace '%s')", m.getName(), m.getNamespace())).collect(Collectors.joining(", "));
            String message = String.format("Naming collision for types named: %s defined in the DMN models: %s (colliding on '%s')", collidingOverName, modelsCoords, kv.getKey());
            messages.add(message);
        }
        throw new IllegalStateException("Couldn't determine unique naming policy.\nEnsure all DMN models are defined in their own namespace.\n" + messages.stream().collect(Collectors.joining("\n")));
    }

    private boolean namingIntegrityCheck() {
        return (long)this.typesIndex.size() == this.typesIndex.stream().map(this.namingPolicy::getName).distinct().count();
    }

    private void assignNamesToIOSets() {
        long byNameCount = this.dmnModels.stream().map(DMNModel::getName).distinct().count();
        if ((long)this.dmnModels.size() == byNameCount) {
            for (DMNModelIOSets si : this.ioSets) {
                si.setInputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("InputSet", si.getModel().getName())));
                si.setOutputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("OutputSet", si.getModel().getName())));
                for (DMNModelIOSets.DSIOSets ds : si.getDSIOSets()) {
                    ds.setDSInputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("InputSet", si.getModel().getName()) + "DS" + ds.getDS().getName()));
                    ds.setDSOutputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("OutputSet", si.getModel().getName()) + "DS" + ds.getDS().getName()));
                }
            }
        } else {
            LOG.warn("DMN model names are not unique across all namespaces, using number-based naming for InputSet/OutputSet(s)");
            for (int i = 0; i < this.ioSets.size(); ++i) {
                DMNModelIOSets si = this.ioSets.get(i);
                si.setInputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("InputSet", i + 1)));
                si.setOutputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("OutputSet", i + 1)));
                int j = 1;
                for (DMNModelIOSets.DSIOSets ds : si.getDSIOSets()) {
                    ds.setDSInputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("InputSet", i + 1) + "DS" + j));
                    ds.setDSOutputSetName(this.ensureUniqueName(this.buildRadixNameForIOSet("OutputSet", i + 1) + "DS" + j));
                    ++j;
                }
            }
        }
    }

    private String ensureUniqueName(String candidate) {
        while (this.indexContainsName((String)candidate)) {
            candidate = "_" + (String)candidate;
        }
        return candidate;
    }

    private String buildRadixNameForIOSet(String radix, int suffixH) {
        return this.buildRadixNameForIOSet(radix, Integer.valueOf(suffixH).toString());
    }

    private String buildRadixNameForIOSet(String radix, String suffixH) {
        return this.dmnModels.size() > 1 ? radix + suffixH : radix;
    }

    private boolean indexContainsName(String candidate) {
        return this.typesIndex.stream().map(DMNType::getName).anyMatch(candidate::equals);
    }

    private void visitForIndexing(DMNModelIOSets s) {
        this.visitForIndexing(s.getOutputSet());
        this.visitForIndexing(s.getInputSet());
        for (DMNModelIOSets.DSIOSets ds : s.getDSIOSets()) {
            this.visitForIndexing(ds.getDSOutputSet());
            this.visitForIndexing(ds.getDSInputSet());
        }
    }

    private void visitForIndexing(DMNType idnType) {
        if (this.typesIndex.contains(idnType)) {
            return;
        }
        if (DMNTypeUtils.isFEELBuiltInType((DMNType)idnType)) {
            return;
        }
        this.typesIndex.add(idnType);
        if (idnType.getBaseType() != null) {
            this.visitForIndexing(idnType.getBaseType());
        }
        if (idnType instanceof CompositeTypeImpl) {
            CompositeTypeImpl compType = (CompositeTypeImpl)idnType;
            for (DMNType v : compType.getFields().values()) {
                this.visitForIndexing(v);
            }
        }
    }
}

