/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.drools.util.functions.TriConsumer;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.feel.lang.ast.InfixOperator;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.CountFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FEELFunctionSchemaMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FEELFunctionSchemaMapper.class);
    static final Map<Class<? extends FEELFunction>, TriConsumer<InfixOperator, Object, Schema>> SCHEMA_MODIFIERS;
    private static TriConsumer<InfixOperator, Object, Schema> COUNT_CONSUMER;

    static void populateSchemaFromFEELFunction(FEELFunction function, InfixOperator operator, Object rightValue, Schema toPopulate) {
        if (SCHEMA_MODIFIERS.containsKey(function.getClass())) {
            SCHEMA_MODIFIERS.get(function.getClass()).accept((Object)operator, rightValue, (Object)toPopulate);
        }
    }

    private FEELFunctionSchemaMapper() {
    }

    static {
        COUNT_CONSUMER = (o, rightValue, schema) -> {
            switch (o) {
                case GT: {
                    schema.setMinItems(Integer.valueOf(((BigDecimal)rightValue).intValue() + 1));
                    break;
                }
                case GTE: {
                    schema.setMinItems(Integer.valueOf(((BigDecimal)rightValue).intValue()));
                    break;
                }
                case LT: {
                    schema.setMaxItems(Integer.valueOf(((BigDecimal)rightValue).intValue() - 1));
                    break;
                }
                case LTE: {
                    schema.setMaxItems(Integer.valueOf(((BigDecimal)rightValue).intValue()));
                    break;
                }
                case EQ: {
                    schema.setMinItems(Integer.valueOf(((BigDecimal)rightValue).intValue()));
                    schema.setMaxItems(Integer.valueOf(((BigDecimal)rightValue).intValue()));
                    break;
                }
                default: {
                    LOG.debug("Ignore operator {}", o);
                }
            }
        };
        SCHEMA_MODIFIERS = new HashMap<Class<? extends FEELFunction>, TriConsumer<InfixOperator, Object, Schema>>();
        SCHEMA_MODIFIERS.put(CountFunction.class, COUNT_CONSUMER);
    }
}

