/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.prototype;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.drools.model.AlphaIndex;
import org.drools.model.BetaIndex;
import org.drools.model.ConstraintOperator;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.temporal.TemporalPredicate;
import org.drools.model.prototype.PrototypeExpression;
import org.drools.model.prototype.PrototypeVariable;
import org.drools.model.prototype.impl.PrototypeVariableImpl;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeBuilder;
import org.kie.api.prototype.PrototypeEvent;
import org.kie.api.prototype.PrototypeFact;
import org.kie.api.prototype.PrototypeFactInstance;

public class PrototypeDSL {
    static final PrototypeFact DEFAULT_PROTOTYPE = PrototypeBuilder.prototype((String)"$DEFAULT_PROTOTYPE$").asFact();

    public static PrototypeFact prototypeFact(String name) {
        return PrototypeBuilder.prototype((String)name).asFact();
    }

    public static PrototypeEvent prototypeEvent(String name) {
        return PrototypeBuilder.prototype((String)name).asEvent();
    }

    public static PrototypeVariable variable(Prototype prototype) {
        return new PrototypeVariableImpl(prototype);
    }

    public static PrototypeVariable variable(Prototype prototype, String name) {
        return new PrototypeVariableImpl(prototype, name);
    }

    public static PrototypePatternDef protoPattern(PrototypeVariable protoVar) {
        return new PrototypePatternDefImpl(protoVar);
    }

    public static PrototypeExpression fieldName2PrototypeExpression(String fieldName) {
        int arrayStart = fieldName.indexOf(91);
        if (arrayStart >= 0) {
            int arrayEnd = fieldName.indexOf(93);
            int pos = Integer.parseInt(fieldName.substring(arrayStart + 1, arrayEnd));
            PrototypeExpression arrayExpr = PrototypeExpression.prototypeArrayItem(fieldName.substring(0, arrayStart), pos);
            if (arrayEnd + 1 < fieldName.length()) {
                if (fieldName.charAt(arrayEnd + 1) != '.') {
                    throw new UnsupportedOperationException("Invalid expression: " + fieldName);
                }
                arrayExpr = arrayExpr.andThen(PrototypeDSL.fieldName2PrototypeExpression(fieldName.substring(arrayEnd + 2)));
            }
            return arrayExpr;
        }
        return PrototypeExpression.prototypeField(fieldName);
    }

    public static class PrototypePatternDefImpl
    extends PatternDSL.PatternDefImpl<PrototypeFactInstance>
    implements PrototypePatternDef {
        public PrototypePatternDefImpl(PrototypeVariable variable) {
            super((Variable)variable);
        }

        public PrototypeVariable getPrototypeVariable() {
            return (PrototypeVariable)this.getFirstVariable();
        }

        public Prototype getPrototype() {
            return this.getPrototypeVariable().getPrototype();
        }

        @Override
        public PrototypePatternDef and() {
            return new PrototypeSubPatternDefImpl(this, PatternDSL.LogicalCombiner.AND);
        }

        @Override
        public PrototypePatternDef or() {
            return new PrototypeSubPatternDefImpl(this, PatternDSL.LogicalCombiner.OR);
        }

        @Override
        public PrototypePatternDef expr(String fieldName, ConstraintOperator operator, Object value) {
            return this.expr(PrototypeDSL.fieldName2PrototypeExpression(fieldName), operator, PrototypeExpression.fixedValue(value));
        }

        @Override
        public PrototypePatternDef expr(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
            if (right.hasPrototypeVariable()) {
                return this.exprWithProtoDef(left, operator, right);
            }
            Prototype prototype = this.getPrototype();
            Function1<PrototypeFactInstance, Object> leftExtractor = left.asFunction(prototype);
            HashSet<String> reactOnFields = new HashSet<String>();
            reactOnFields.addAll(left.getImpactedFields());
            reactOnFields.addAll(right.getImpactedFields());
            this.expr(PrototypePatternDefImpl.createExprId(left, operator, right), this.asPredicate1(leftExtractor, operator, right.asFunction(prototype)), PrototypePatternDefImpl.createAlphaIndex(left, operator, right, prototype, leftExtractor), PatternDSL.reactOn((String[])reactOnFields.toArray(new String[reactOnFields.size()])));
            return this;
        }

        private static AlphaIndex createAlphaIndex(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right, Prototype prototype, Function1<PrototypeFactInstance, Object> leftExtractor) {
            if (left.getIndexingKey().isPresent() && right instanceof PrototypeExpression.FixedValue && operator instanceof Index.ConstraintType) {
                Class fieldClass;
                Index.ConstraintType constraintType = (Index.ConstraintType)operator;
                String fieldName = left.getIndexingKey().get();
                Prototype.Field field = prototype.getField(fieldName);
                Object value = ((PrototypeExpression.FixedValue)right).getValue();
                Class clazz = field != null && field.isTyped() ? field.getType() : (fieldClass = value != null ? value.getClass() : null);
                if (fieldClass != null) {
                    return PatternDSL.alphaIndexedBy((Class)fieldClass, (Index.ConstraintType)constraintType, (int)PrototypePatternDefImpl.getFieldIndex(prototype, fieldName, field), leftExtractor, (Object)value);
                }
            }
            return null;
        }

        private static int getFieldIndex(Prototype prototype, String fieldName, Prototype.Field field) {
            return field != null ? prototype.getFieldIndex(fieldName) : Math.abs(fieldName.hashCode());
        }

        @Override
        public PrototypePatternDef expr(String fieldName, ConstraintOperator operator, PrototypeVariable other, String otherFieldName) {
            return this.expr(PrototypeDSL.fieldName2PrototypeExpression(fieldName), operator, other, PrototypeDSL.fieldName2PrototypeExpression(otherFieldName));
        }

        @Override
        public PrototypePatternDef expr(PrototypeExpression left, ConstraintOperator operator, PrototypeVariable other, PrototypeExpression right) {
            Prototype prototype = this.getPrototype();
            Prototype otherPrototype = other.getPrototype();
            HashSet<String> reactOnFields = new HashSet<String>();
            reactOnFields.addAll(left.getImpactedFields());
            reactOnFields.addAll(right.getImpactedFields());
            this.expr(PrototypePatternDefImpl.createExprId(left, operator, right), other, this.asPredicate2(left.asFunction(prototype), operator, right.asFunction(otherPrototype)), this.createBetaIndex(left, operator, right, prototype, otherPrototype), PatternDSL.reactOn((String[])reactOnFields.toArray(new String[reactOnFields.size()])));
            return this;
        }

        private static String createExprId(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
            String leftId = left.getIndexingKey().orElse(left.toString());
            PrototypeExpression rightId = right instanceof PrototypeExpression.FixedValue ? ((PrototypeExpression.FixedValue)right).getValue() : right;
            return "expr:" + leftId + ":" + operator + ":" + rightId;
        }

        private BetaIndex createBetaIndex(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right, Prototype prototype, Prototype otherPrototype) {
            if (left.getIndexingKey().isPresent() && operator instanceof Index.ConstraintType) {
                Index.ConstraintType constraintType = (Index.ConstraintType)operator;
                if (right.getIndexingKey().isPresent()) {
                    String fieldName = left.getIndexingKey().get();
                    Prototype.Field field = prototype.getField(fieldName);
                    Function1<PrototypeFactInstance, Object> extractor = left.asFunction(prototype);
                    Function1<PrototypeFactInstance, Object> otherExtractor = right.asFunction(otherPrototype);
                    Class fieldClass = field != null && field.isTyped() ? field.getType() : Object.class;
                    return PatternDSL.betaIndexedBy((Class)fieldClass, (Index.ConstraintType)constraintType, (int)PrototypePatternDefImpl.getFieldIndex(prototype, fieldName, field), extractor, otherExtractor);
                }
            }
            return null;
        }

        @Override
        public PrototypePatternDef expr(TemporalPredicate temporalPredicate, PrototypeVariable other) {
            if (!this.getPrototype().isEvent() || !other.getPrototype().isEvent()) {
                throw new UnsupportedOperationException("Use of temporal predicates is allowed only on events, not on facts.");
            }
            this.expr(UUID.randomUUID().toString(), other, temporalPredicate);
            return this;
        }

        private Predicate1<PrototypeFactInstance> asPredicate1(Function1<PrototypeFactInstance, Object> left, ConstraintOperator operator, Function1<PrototypeFactInstance, Object> right) {
            return (Predicate1 & Serializable)p -> {
                Object leftValue = left.apply(p);
                Object rightValue = right.apply(p);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private Predicate2<PrototypeFactInstance, PrototypeFactInstance> asPredicate2(Function1<PrototypeFactInstance, Object> extractor, ConstraintOperator operator, Function1<PrototypeFactInstance, Object> otherExtractor) {
            return (Predicate2 & Serializable)(p1, p2) -> {
                Object leftValue = extractor.apply(p1);
                Object rightValue = otherExtractor.apply(p2);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private PrototypePatternDef exprWithProtoDef(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
            PrototypeVariable leftVar = this.getPrototypeVariable();
            PrototypeVariable[] protoVars = this.findRightPrototypeVariables(right, leftVar);
            if (protoVars.length != 2) {
                throw new UnsupportedOperationException();
            }
            this.expr("expr:" + left + ":" + operator + ":" + right, protoVars[0], protoVars[1], this.asPredicate3(leftVar, left, operator, (PrototypeExpression.EvaluableExpression)((Object)right), protoVars));
            return this;
        }

        private Predicate3<PrototypeFactInstance, PrototypeFactInstance, PrototypeFactInstance> asPredicate3(PrototypeVariable leftVar, PrototypeExpression left, ConstraintOperator operator, PrototypeExpression.EvaluableExpression right, PrototypeVariable[] protoVars) {
            return (Predicate3 & Serializable)(l, r1, r2) -> {
                HashMap<PrototypeVariable, PrototypeFactInstance> factsMap = new HashMap<PrototypeVariable, PrototypeFactInstance>();
                factsMap.put(leftVar, (PrototypeFactInstance)l);
                factsMap.put(protoVars[0], (PrototypeFactInstance)r1);
                factsMap.put(protoVars[1], (PrototypeFactInstance)r2);
                Object leftValue = left.asFunction(this.getPrototype()).apply(l);
                Object rightValue = right.evaluate(factsMap);
                return PrototypePatternDefImpl.evaluateConstraint(leftValue, operator, rightValue);
            };
        }

        private PrototypeVariable[] findRightPrototypeVariables(PrototypeExpression right, PrototypeVariable leftVar) {
            Collection<PrototypeVariable> rightVars = right.getPrototypeVariables();
            boolean rightVarsContainLeft = rightVars.contains(leftVar);
            PrototypeVariable[] protoVars = new PrototypeVariable[rightVarsContainLeft ? rightVars.size() - 1 : rightVars.size()];
            int i = 0;
            for (PrototypeVariable rightVar : rightVars) {
                if (rightVarsContainLeft && rightVar == leftVar) continue;
                protoVars[i++] = rightVar;
            }
            return protoVars;
        }

        private static boolean evaluateConstraint(Object leftValue, ConstraintOperator operator, Object rightValue) {
            return leftValue != Prototype.UNDEFINED_VALUE && rightValue != Prototype.UNDEFINED_VALUE && operator.asPredicate().test(leftValue, rightValue);
        }
    }

    public static class PrototypeSubPatternDefImpl
    extends PrototypePatternDefImpl {
        private final PrototypePatternDefImpl parent;
        private final PatternDSL.LogicalCombiner combiner;

        public PrototypeSubPatternDefImpl(PrototypePatternDefImpl parent, PatternDSL.LogicalCombiner combiner) {
            super((PrototypeVariable)parent.getFirstVariable());
            this.parent = parent;
            this.combiner = combiner;
        }

        public PrototypePatternDefImpl endAnd() {
            if (this.combiner == PatternDSL.LogicalCombiner.OR) {
                throw new UnsupportedOperationException();
            }
            this.parent.getItems().add(new PatternDSL.CombinedPatternExprItem(this.combiner, this.getItems()));
            return this.parent;
        }

        public PrototypePatternDefImpl endOr() {
            if (this.combiner == PatternDSL.LogicalCombiner.AND) {
                throw new UnsupportedOperationException();
            }
            this.parent.getItems().add(new PatternDSL.CombinedPatternExprItem(this.combiner, this.getItems()));
            return this.parent;
        }
    }

    public static interface PrototypePatternDef
    extends PatternDSL.PatternDef<PrototypeFactInstance> {
        public PrototypePatternDef expr(String var1, ConstraintOperator var2, Object var3);

        public PrototypePatternDef expr(PrototypeExpression var1, ConstraintOperator var2, PrototypeExpression var3);

        public PrototypePatternDef expr(String var1, ConstraintOperator var2, PrototypeVariable var3, String var4);

        public PrototypePatternDef expr(PrototypeExpression var1, ConstraintOperator var2, PrototypeVariable var3, PrototypeExpression var4);

        public PrototypePatternDef expr(TemporalPredicate var1, PrototypeVariable var2);

        public PrototypePatternDef and();

        public PrototypePatternDef or();
    }
}

