/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.prototype.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.drools.model.functions.temporal.TimeUtil;
import org.drools.model.prototype.impl.HashMapFactImpl;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeEventInstance;

public class HashMapEventImpl
extends HashMapFactImpl
implements PrototypeEventInstance {
    private long timestamp = -1L;
    private long expiration = Long.MAX_VALUE;

    public HashMapEventImpl(Prototype prototype) {
        this(prototype, new HashMap<String, Object>());
    }

    public HashMapEventImpl(Prototype prototype, Map<String, Object> valuesMap) {
        super(prototype, valuesMap);
    }

    public HashMapEventImpl(UUID uuid, Prototype prototype, Map<String, Object> valuesMap, long timestamp, long expiration) {
        super(uuid, prototype, valuesMap);
        this.timestamp = timestamp;
        this.expiration = expiration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public HashMapEventImpl withExpiration(long value, TimeUnit unit) {
        this.expiration = TimeUtil.unitToLong((long)value, (TimeUnit)unit);
        return this;
    }

    @Override
    public String toString() {
        return "Event " + this.prototype.getFullName() + " with values = " + this.valuesMap;
    }
}

