/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.prototype.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeFactInstance;

public class HashMapFactImpl
implements PrototypeFactInstance,
Serializable {
    protected final UUID uuid;
    protected final Prototype prototype;
    protected final Map<String, Object> valuesMap;

    public HashMapFactImpl(Prototype prototype) {
        this(prototype, new HashMap<String, Object>());
    }

    public HashMapFactImpl(Prototype prototype, Map<String, Object> valuesMap) {
        this.uuid = UUID.randomUUID();
        this.prototype = prototype;
        this.valuesMap = valuesMap;
    }

    public HashMapFactImpl(UUID uuid, Prototype prototype, Map<String, Object> valuesMap) {
        this.uuid = uuid;
        this.prototype = prototype;
        this.valuesMap = valuesMap;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Prototype getPrototype() {
        return this.prototype;
    }

    public boolean has(String name) {
        return this.valuesMap.containsKey(name);
    }

    public Object get(String name) {
        return this.valuesMap.get(name);
    }

    public void put(String name, Object value) {
        this.valuesMap.put(name, value);
    }

    public Map<String, Object> asMap() {
        return this.valuesMap;
    }

    public String toString() {
        return "Fact " + this.prototype.getFullName() + " with values = " + this.valuesMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashMapFactImpl other = (HashMapFactImpl)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

