/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.prototype.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.drools.core.reteoo.CoreComponentFactory;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeFactInstance;

public abstract class PrototypeImpl
implements Prototype,
Serializable {
    private final String pkg;
    private final String name;
    private final SortedMap<String, Prototype.Field> fields;

    public PrototypeImpl(String fulllName, List<Prototype.Field> fields) {
        int lastDot = fulllName.lastIndexOf(46);
        this.pkg = lastDot > 0 ? fulllName.substring(0, lastDot) : "defaultpkg";
        this.name = lastDot > 0 ? fulllName.substring(lastDot + 1) : fulllName;
        this.fields = this.initFields(fields);
        this.registerPrototype();
    }

    public PrototypeImpl(String pkg, String name, List<Prototype.Field> fields) {
        this.pkg = pkg != null && !pkg.isEmpty() ? pkg : "defaultpkg";
        this.name = name;
        this.fields = this.initFields(fields);
        this.registerPrototype();
    }

    private void registerPrototype() {
        CoreComponentFactory.get().createKnowledgePackage(this.pkg).addPrototype((Prototype)this);
    }

    private SortedMap<String, Prototype.Field> initFields(List<Prototype.Field> fields) {
        SortedMap<String, Prototype.Field> sortedFields;
        if (fields != null && !fields.isEmpty()) {
            sortedFields = new TreeMap<String, Prototype.Field>();
            for (Prototype.Field field : fields) {
                sortedFields.put(field.getName(), field);
            }
        } else {
            sortedFields = Collections.emptySortedMap();
        }
        return sortedFields;
    }

    public String getPackage() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    public Prototype.Field getField(String name) {
        return (Prototype.Field)this.fields.get(name);
    }

    public int getFieldIndex(String name) {
        int i = 0;
        for (String field : this.fields.keySet()) {
            if (field.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrototypeImpl)) {
            return false;
        }
        PrototypeImpl prototype = (PrototypeImpl)o;
        return this.pkg.equals(prototype.pkg) && this.name.equals(prototype.name) && this.fields.equals(prototype.fields);
    }

    public int hashCode() {
        return Objects.hash(this.pkg, this.name, this.fields);
    }

    public static class FieldImpl
    implements Prototype.Field,
    Serializable {
        private final String name;
        private final Function<PrototypeFactInstance, Object> extractor;
        private final boolean typed;
        private final Class<?> type;

        public FieldImpl(String name) {
            this(name, (PrototypeFactInstance p) -> p.get(name));
        }

        public FieldImpl(String name, Function<PrototypeFactInstance, Object> extractor) {
            this.name = name;
            this.extractor = extractor;
            this.type = Object.class;
            this.typed = false;
        }

        public FieldImpl(String name, Class<?> type) {
            this(name, type, p -> p.get(name));
        }

        public FieldImpl(String name, Class<?> type, Function<PrototypeFactInstance, Object> extractor) {
            this.name = name;
            this.extractor = extractor;
            this.type = type;
            this.typed = true;
        }

        public String getName() {
            return this.name;
        }

        public Function<PrototypeFactInstance, Object> getExtractor() {
            return this.extractor;
        }

        public boolean isTyped() {
            return this.typed;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

