/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunits.impl.datasources;

import java.util.Iterator;
import org.drools.ruleunits.api.DataProcessor;
import org.drools.ruleunits.api.DataStream;
import org.drools.ruleunits.impl.datasources.AbstractDataSource;

public class BufferedDataStream<T>
extends AbstractDataSource<T>
implements DataStream<T> {
    private final LimitedBufferedList<T> list;

    protected BufferedDataStream(int size) {
        this.list = new LimitedBufferedList(size);
    }

    public void append(T value) {
        this.list.add(value);
        this.forEachSubscriber(s -> s.insert(value));
    }

    @Override
    public void subscribe(DataProcessor<T> subscriber) {
        super.subscribe(subscriber);
        this.list.forEach(arg_0 -> subscriber.insert(arg_0));
    }

    private static class LimitedBufferedList<T>
    implements Iterable<T> {
        private final T[] array;
        private int head = 0;

        LimitedBufferedList(int size) {
            this.array = new Object[size];
        }

        void add(T value) {
            this.array[this.head++ % this.array.length] = value;
        }

        int size() {
            return Math.min(this.head, this.array.length);
        }

        @Override
        public Iterator<T> iterator() {
            return new BufferedIterator();
        }

        private class BufferedIterator
        implements Iterator<T> {
            private int cursor = 0;

            private BufferedIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.cursor < LimitedBufferedList.this.size();
            }

            @Override
            public T next() {
                return LimitedBufferedList.this.head < LimitedBufferedList.this.array.length ? LimitedBufferedList.this.array[this.cursor++] : LimitedBufferedList.this.array[(LimitedBufferedList.this.head + this.cursor++) % LimitedBufferedList.this.array.length];
            }
        }
    }
}

