/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.local.shap;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.PredictionInput;

public class ShapSyntheticDataSample {
    private final PredictionInput x;
    private final boolean[] mask;
    private final RealMatrix background;
    private double weight;
    private final boolean fixed;
    private final List<PredictionInput> syntheticData;

    public ShapSyntheticDataSample(PredictionInput x, boolean[] mask, RealMatrix background, double weight, boolean fixed) {
        this.x = x;
        this.mask = mask;
        this.background = background;
        this.weight = weight;
        this.fixed = fixed;
        this.syntheticData = this.createSyntheticData();
    }

    private List<PredictionInput> createSyntheticData() {
        List<Feature> piFeatures = this.x.getFeatures();
        ArrayList<PredictionInput> synthData = new ArrayList<PredictionInput>();
        for (int i = 0; i < this.background.getRowDimension(); ++i) {
            ArrayList<Feature> maskedFeatures = new ArrayList<Feature>();
            for (int j = 0; j < this.mask.length; ++j) {
                Feature oldFeature = piFeatures.get(j);
                if (this.mask[j]) {
                    maskedFeatures.add(oldFeature);
                    continue;
                }
                maskedFeatures.add(FeatureFactory.newNumericalFeature(oldFeature.getName(), this.background.getEntry(i, j)));
            }
            synthData.add(new PredictionInput(maskedFeatures));
        }
        return synthData;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public List<PredictionInput> getSyntheticData() {
        return this.syntheticData;
    }

    public boolean[] getMask() {
        return this.mask;
    }

    public void incrementWeight() {
        this.weight += 1.0;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }
}

