/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.compiler.DMNOption;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.internal.utils.DMNRuntimeBuilder;
import org.kie.dmn.core.internal.utils.DynamicDMNContextBuilder;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.jitexecutor.common.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.common.requests.ResourceWithURI;
import org.kie.kogito.jitexecutor.dmn.utils.ResolveByKey;

public class DMNEvaluator {
    private final DMNModel dmnModel;
    private final DMNRuntime dmnRuntime;

    public static DMNEvaluator fromXML(String modelXML) {
        Resource modelResource = ResourceFactory.newReaderResource((Reader)new StringReader(modelXML), (String)"UTF-8");
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().buildConfiguration().fromResources(Collections.singletonList(modelResource)).getOrElseThrow(RuntimeException::new);
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        return new DMNEvaluator(dmnModel, dmnRuntime);
    }

    private DMNEvaluator(DMNModel dmnModel, DMNRuntime dmnRuntime) {
        this.dmnModel = dmnModel;
        this.dmnRuntime = dmnRuntime;
        ((DMNRuntimeImpl)this.dmnRuntime).setOption((DMNOption)new RuntimeTypeCheckOption(true));
    }

    public DMNModel getDmnModel() {
        return this.dmnModel;
    }

    public String getNamespace() {
        return this.dmnModel.getNamespace();
    }

    public String getName() {
        return this.dmnModel.getName();
    }

    public Collection<DMNModel> getAllDMNModels() {
        return this.dmnRuntime.getModels();
    }

    public DMNResult evaluate(Map<String, Object> context) {
        DMNContext dmnContext = new DynamicDMNContextBuilder(this.dmnRuntime.newContext(), this.dmnModel).populateContextWith(context);
        return this.dmnRuntime.evaluateAll(this.dmnModel, dmnContext);
    }

    public static DMNEvaluator fromMultiple(MultipleResourcesPayload payload) {
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        for (ResourceWithURI r : payload.getResources()) {
            Resource readerResource = ResourceFactory.newReaderResource((Reader)new StringReader(r.getContent()), (String)"UTF-8");
            readerResource.setSourcePath(r.getURI());
            resources.put(r.getURI(), readerResource);
        }
        ResolveByKey rbk = new ResolveByKey(resources);
        DMNRuntime dmnRuntime = (DMNRuntime)DMNRuntimeBuilder.fromDefaults().setRelativeImportResolver((x, y, locationURI) -> rbk.readerByKey(locationURI)).buildConfiguration().fromResources(resources.values()).getOrElseThrow(RuntimeException::new);
        DMNModel mainModel = null;
        for (DMNModel m : dmnRuntime.getModels()) {
            if (!m.getResource().getSourcePath().equals(payload.getMainURI())) continue;
            mainModel = m;
            break;
        }
        if (mainModel == null) {
            throw new IllegalStateException("Was not able to identify main model from MultipleResourcesPayload contents.");
        }
        return new DMNEvaluator(mainModel, dmnRuntime);
    }
}

