/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.kie.dmn.core.internal.utils.MarshallingStubUtils;
import org.kie.kogito.jitexecutor.dmn.JITDMNService;
import org.kie.kogito.jitexecutor.dmn.requests.JITDMNPayload;
import org.kie.kogito.jitexecutor.dmn.responses.DMNResultWithExplanation;
import org.kie.kogito.jitexecutor.dmn.responses.JITDMNResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/jitdmn")
public class JITDMNResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(JITDMNResource.class);
    @Inject
    JITDMNService jitdmnService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitdmn(JITDMNPayload payload) {
        LOGGER.debug("******\n");
        LOGGER.debug("jitdmn/");
        LOGGER.debug(payload.toString());
        LOGGER.debug("******\n");
        JITDMNResult evaluateAll = payload.getModel() != null ? this.jitdmnService.evaluateModel(payload.getModel(), payload.getContext()) : this.jitdmnService.evaluateModel(payload, payload.getContext());
        HashMap<String, Object> restResulk = new HashMap<String, Object>();
        for (Map.Entry kv : evaluateAll.getContext().getAll().entrySet()) {
            restResulk.put((String)kv.getKey(), MarshallingStubUtils.stubDMNResult(kv.getValue(), String::valueOf));
        }
        return Response.ok(restResulk).build();
    }

    @POST
    @Path(value="/dmnresult")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitdmnResult(JITDMNPayload payload) {
        LOGGER.debug("******\n");
        LOGGER.debug("jitdmn/dmnresult");
        LOGGER.debug(payload.toString());
        LOGGER.debug("******\n");
        JITDMNResult dmnResult = payload.getModel() != null ? this.jitdmnService.evaluateModel(payload.getModel(), payload.getContext()) : this.jitdmnService.evaluateModel(payload, payload.getContext());
        return Response.ok((Object)dmnResult).build();
    }

    @POST
    @Path(value="/evaluateAndExplain")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response jitEvaluateAndExplain(JITDMNPayload payload) {
        LOGGER.debug("******\n");
        LOGGER.debug("jitdmn/evaluateAndExplain");
        LOGGER.debug(payload.toString());
        LOGGER.debug("******\n");
        DMNResultWithExplanation response = payload.getModel() != null ? this.jitdmnService.evaluateModelAndExplain(payload.getModel(), payload.getContext()) : this.jitdmnService.evaluateModelAndExplain(payload, payload.getContext());
        return Response.ok((Object)response).build();
    }
}

