/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jitexecutor.dmn.api;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.schema.SchemaWriter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.spi.OASFactoryResolver;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.openapi.DMNOASGeneratorFactory;
import org.kie.dmn.openapi.model.DMNOASResult;
import org.kie.kogito.jitexecutor.common.requests.MultipleResourcesPayload;
import org.kie.kogito.jitexecutor.dmn.DMNEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="jitdmn/schema")
public class SchemaResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaResource.class);
    static final OpenAPI x;
    static Schema resourceWithURI;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response schema(String payload) {
        LOGGER.debug("******\n");
        LOGGER.debug("jitdmn/validate");
        LOGGER.debug(payload);
        LOGGER.debug("******\n");
        DMNModel dmnModel = DMNEvaluator.fromXML(payload).getDmnModel();
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(Collections.singletonList(dmnModel)).build();
        return this.fullSchema(dmnModel, oasResult, true);
    }

    private Response fullSchema(DMNModel dmnModel, DMNOASResult oasResult, boolean singleModel) {
        ObjectNode jsNode = oasResult.getJsonSchemaNode();
        DMNType is = oasResult.lookupIOSetsByModel(dmnModel).getInputSet();
        String isRef = oasResult.getNamingPolicy().getRef(is);
        Schema schema = ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT);
        schema.addProperty("context", (Schema)((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT).ref(isRef));
        if (singleModel) {
            schema.addProperty("model", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING));
        } else {
            schema.addProperty("mainURI", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING));
            schema.addProperty("resources", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.ARRAY).items(resourceWithURI));
        }
        ObjectNode schemasNode = jsNode.putObject("properties");
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            SchemaWriter.writeSchema((ObjectNode)schemasNode, (Schema)((Schema)entry.getValue()), (String)((String)entry.getKey()));
        }
        jsNode.put("type", "object");
        ArrayNode requiredArray = jsNode.putArray("required").add("context");
        if (singleModel) {
            requiredArray.add("model");
        } else {
            requiredArray.add("mainURI").add("resources");
        }
        return Response.ok((Object)jsNode).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response schema(MultipleResourcesPayload payload) {
        DMNEvaluator dmnEvaluator = DMNEvaluator.fromMultiple(payload);
        DMNModel dmnModel = dmnEvaluator.getDmnModel();
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(dmnEvaluator.getAllDMNModels()).build();
        return this.fullSchema(dmnModel, oasResult, false);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    @Path(value="form")
    public Response form(String payload) {
        DMNModel dmnModel = DMNEvaluator.fromXML(payload).getDmnModel();
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(Collections.singletonList(dmnModel)).build();
        return this.formSchema(dmnModel, oasResult);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="form")
    public Response form(MultipleResourcesPayload payload) {
        DMNEvaluator dmnEvaluator = DMNEvaluator.fromMultiple(payload);
        DMNModel dmnModel = dmnEvaluator.getDmnModel();
        DMNOASResult oasResult = DMNOASGeneratorFactory.generator(dmnEvaluator.getAllDMNModels()).build();
        return this.formSchema(dmnModel, oasResult);
    }

    private Response formSchema(DMNModel dmnModel, DMNOASResult oasResult) {
        ObjectNode jsNode = oasResult.getJsonSchemaNode();
        DMNType is = oasResult.lookupIOSetsByModel(dmnModel).getInputSet();
        String isRef = oasResult.getNamingPolicy().getRef(is);
        jsNode.put("$ref", isRef);
        return Response.ok((Object)jsNode).build();
    }

    static {
        OASFactoryResolver.instance();
        x = (OpenAPI)OASFactory.createObject(OpenAPI.class);
        resourceWithURI = ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.OBJECT).addProperty("URI", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING)).addProperty("content", ((Schema)OASFactory.createObject(Schema.class)).type(Schema.SchemaType.STRING)).required(List.of("URI", "content"));
    }
}

