/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XpathAnalysis
implements Iterable<XpathPart> {
    private final List<XpathPart> parts;
    private final String error;

    public XpathAnalysis(List<XpathPart> parts, String error) {
        this.parts = parts;
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String getError() {
        return this.error;
    }

    @Override
    public Iterator<XpathPart> iterator() {
        return this.parts.iterator();
    }

    public List<XpathPart> getParts() {
        return this.parts;
    }

    public XpathPart getPart(int i) {
        return this.parts.get(i);
    }

    public boolean isSinglePart() {
        return this.parts.size() == 1;
    }

    public static XpathAnalysis analyze(String xpath) {
        ArrayList<XpathPart> parts = new ArrayList<XpathPart>();
        boolean lazyPath = false;
        int i = 0;
        if (xpath.length() >= 1 && xpath.charAt(0) == '/') {
            i = 1;
        } else if (xpath.length() >= 2 && xpath.charAt(0) == '?' && xpath.charAt(1) == '/') {
            lazyPath = true;
            i = 2;
        } else {
            return new XpathAnalysis(parts, "An oopath expression has to start with '/' or '?/'");
        }
        ArrayList<String> constraints = new ArrayList<String>();
        String inlineCast = null;
        int index = -1;
        int lastStart = i;
        int nestedParam = 0;
        int nestedSquare = 0;
        boolean iterate = true;
        boolean isQuoted = false;
        boolean isDoubleQuoted = false;
        boolean isInlineCast = false;
        String field = null;
        String error = null;
        int partStart = 0;
        while (i < xpath.length() && error == null) {
            switch (xpath.charAt(i)) {
                case '.': 
                case '/': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 0) break;
                    if (field == null) {
                        field = xpath.substring(lastStart, xpath.charAt(i - 1) == '?' ? i - 1 : i).trim();
                    } else if (isInlineCast) {
                        inlineCast = xpath.substring(lastStart, xpath.charAt(i - 1) == '?' ? i - 1 : i).trim();
                        isInlineCast = false;
                    }
                    parts.add(new XpathPart(field, iterate, lazyPath, constraints, inlineCast, index, partStart));
                    partStart = i;
                    boolean bl = iterate = xpath.charAt(i) == '/';
                    if (xpath.charAt(i - 1) == '?') {
                        if (lazyPath) {
                            error = "It is not possible to have 2 non-reactive parts in the same oopath";
                            break;
                        }
                        lazyPath = true;
                    }
                    constraints = new ArrayList();
                    inlineCast = null;
                    index = -1;
                    lastStart = i + 1;
                    field = null;
                    break;
                }
                case '(': {
                    if (isQuoted) break;
                    ++nestedParam;
                    break;
                }
                case ')': {
                    if (isQuoted || --nestedParam >= 0) break;
                    error = "Unbalanced parenthesis";
                    break;
                }
                case '#': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 0) break;
                    if (field == null) {
                        field = xpath.substring(lastStart, i).trim();
                    }
                    lastStart = i + 1;
                    isInlineCast = true;
                    break;
                }
                case '[': {
                    if (isQuoted || nestedParam != 0) break;
                    if (nestedSquare == 0) {
                        if (field == null) {
                            field = xpath.substring(lastStart, i).trim();
                        } else if (isInlineCast) {
                            inlineCast = xpath.substring(lastStart, i).trim();
                            isInlineCast = false;
                        }
                        lastStart = i + 1;
                    }
                    ++nestedSquare;
                    break;
                }
                case ']': {
                    String constraint;
                    if (isQuoted || nestedParam != 0) break;
                    if (--nestedSquare == 0) {
                        constraint = xpath.substring(lastStart, i).trim();
                        if (Character.isDigit(constraint.charAt(0))) {
                            try {
                                index = Integer.parseInt(constraint);
                            }
                            catch (Exception e) {
                                constraints.add(constraint);
                            }
                            break;
                        }
                        constraints.add(constraint);
                        break;
                    }
                    if (nestedSquare >= 0) break;
                    error = "Unbalanced square brackets";
                    break;
                }
                case ',': {
                    if (isQuoted || nestedParam != 0 || nestedSquare != 1) break;
                    String constraint = xpath.substring(lastStart, i).trim();
                    constraints.add(constraint);
                    lastStart = i + 1;
                    break;
                }
                case '\"': {
                    if (isQuoted) {
                        if (!isDoubleQuoted) break;
                        isQuoted = false;
                        isDoubleQuoted = false;
                        break;
                    }
                    isQuoted = true;
                    isDoubleQuoted = true;
                    break;
                }
                case '\'': {
                    if (isQuoted) {
                        if (isDoubleQuoted) break;
                        isQuoted = false;
                        break;
                    }
                    isQuoted = true;
                }
            }
            ++i;
        }
        if (field == null) {
            field = xpath.substring(lastStart).trim();
        } else if (isInlineCast) {
            inlineCast = xpath.substring(lastStart).trim();
            isInlineCast = false;
        }
        parts.add(new XpathPart(field, iterate, lazyPath, constraints, inlineCast, index, partStart));
        return new XpathAnalysis(parts, error);
    }

    public static class XpathPart {
        private final String field;
        private final boolean iterate;
        private final boolean lazy;
        private final List<String> constraints;
        private final String inlineCast;
        private final int index;
        private final int start;

        public XpathPart(String field, boolean iterate, boolean lazy, List<String> constraints, String inlineCast, int index, int start) {
            this.field = field;
            this.iterate = iterate;
            this.lazy = lazy;
            this.constraints = constraints;
            this.inlineCast = inlineCast;
            this.index = index;
            this.start = start;
        }

        public String getField() {
            return this.field;
        }

        public boolean isIterate() {
            return this.iterate;
        }

        public boolean isLazy() {
            return this.lazy;
        }

        public List<String> getConstraints() {
            return this.constraints;
        }

        public String getInlineCast() {
            return this.inlineCast;
        }

        public int getIndex() {
            return this.index;
        }

        public int getStart() {
            return this.start;
        }

        public void addInlineCastConstraint(Class<?> clazz) {
            this.constraints.add(0, "this instanceof " + clazz.getCanonicalName());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.field);
            if (this.inlineCast != null) {
                sb.append("#").append(this.inlineCast);
            }
            if (this.index >= 0) {
                sb.append("[").append(this.index).append("]");
            }
            if (!this.constraints.isEmpty()) {
                sb.append("[ ");
                sb.append(this.constraints.get(0));
                for (int i = 1; i < this.constraints.size(); ++i) {
                    sb.append(", ").append(this.constraints.get(i));
                }
                sb.append(" ]");
            }
            return sb.toString();
        }
    }
}

