/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentHolder;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.quarkus.smallrye.openapi.runtime.OpenApiRecorder;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

@ApplicationScoped
public class OpenApiDocumentService
implements OpenApiDocumentHolder {
    private static final String OPENAPI_SERVERS = "mp.openapi.servers";
    private static final IndexView EMPTY_INDEX = new Indexer().complete();
    private final OpenApiDocumentHolder documentHolder;
    private final String previousOpenApiServersSystemPropertyValue;

    public OpenApiDocumentService(OASFilter autoSecurityFilter, OpenApiRecorder.UserDefinedRuntimeFilters userDefinedRuntimeFilters, Config config) {
        String servers = config.getOptionalValue("quarkus.smallrye-openapi.servers", String.class).orElse(null);
        this.previousOpenApiServersSystemPropertyValue = System.getProperty(OPENAPI_SERVERS);
        if (servers != null && !servers.isEmpty()) {
            System.setProperty(OPENAPI_SERVERS, servers);
        }
        this.documentHolder = config.getOptionalValue("quarkus.smallrye-openapi.always-run-filter", Boolean.class).orElse(Boolean.FALSE) != false ? new DynamicDocument(config, autoSecurityFilter, userDefinedRuntimeFilters.filters()) : new StaticDocument(config, autoSecurityFilter, userDefinedRuntimeFilters.filters());
    }

    void reset(@Observes ShutdownEvent event) {
        if (this.previousOpenApiServersSystemPropertyValue == null) {
            System.clearProperty(OPENAPI_SERVERS);
        } else {
            System.setProperty(OPENAPI_SERVERS, this.previousOpenApiServersSystemPropertyValue);
        }
    }

    public byte[] getJsonDocument() {
        return this.documentHolder.getJsonDocument();
    }

    public byte[] getYamlDocument() {
        return this.documentHolder.getYamlDocument();
    }

    public OpenApiDocumentService() {
    }
}

