/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient;

import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.StringUtils;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.validator.RecipientValidator;
import org.kie.kogito.jobs.service.validator.ValidationException;

@ApplicationScoped
public class HttpRecipientValidator
implements RecipientValidator {
    public boolean accept(Recipient<?> recipient) {
        return recipient instanceof HttpRecipient;
    }

    public boolean validate(Recipient<?> recipient) {
        if (!(recipient instanceof HttpRecipient)) {
            throw new IllegalArgumentException("Recipient must be a non-null instance of: " + HttpRecipient.class);
        }
        HttpRecipient httpRecipient = (HttpRecipient)recipient;
        if (StringUtils.isBlank((CharSequence)httpRecipient.getUrl())) {
            throw new IllegalArgumentException("HttpRecipient url must have a non empty value.");
        }
        try {
            new URL(httpRecipient.getUrl());
        }
        catch (MalformedURLException e) {
            throw new ValidationException("HttpRecipient must have a valid url.", (Throwable)e);
        }
        return true;
    }
}

