/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.http.recipient;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.job.http.recipient.HttpRecipientValidator;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.validation.ValidatorContext;

class HttpRecipientValidatorTest {
    private static final long MAX_TIMEOUT = 3000L;
    public static final String URL = "http://my_url";
    private HttpRecipientValidator validator;
    private HttpRecipient<?> recipient;

    HttpRecipientValidatorTest() {
    }

    @BeforeEach
    public void setUp() {
        this.validator = new HttpRecipientValidator(3000L);
        this.recipient = new HttpRecipient();
        this.recipient.setUrl(URL);
    }

    @Test
    void acceptNonNull() {
        Assertions.assertThat((boolean)this.validator.accept(this.recipient)).isTrue();
    }

    @Test
    void acceptNull() {
        Assertions.assertThat((boolean)this.validator.accept(null)).isFalse();
    }

    @Test
    void validateSuccessful() {
        Assertions.assertThatNoException().isThrownBy(() -> this.validator.validate(this.recipient, new ValidatorContext()));
    }

    @Test
    void validateNull() {
        this.recipient = null;
        this.testUnsuccessfulValidation("Recipient must be a non-null instance of", new ValidatorContext());
    }

    @Test
    void validateNullURL() {
        this.recipient.setUrl(null);
        this.testUnsuccessfulValidation("HttpRecipient url must have a non empty value.", new ValidatorContext());
    }

    @Test
    void validateMalformedURL() {
        this.recipient.setUrl("bad url");
        this.testUnsuccessfulValidation("HttpRecipient must have a valid url.", new ValidatorContext());
    }

    @Test
    void validateJobExecutionTimeoutOK() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3L)).executionTimeoutUnit(TemporalUnit.SECONDS).build();
        this.validator.validate(this.recipient, new ValidatorContext(job));
    }

    @Test
    void validateJobExecutionTimeoutExceedsMaxTimeoutMillis() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3001L)).build();
        this.testUnsuccessfulValidation("Job executionTimeout configuration can not exceed the HttpRecipient max-timeout-in-millis", new ValidatorContext(job));
    }

    @Test
    void validateJobExecutionTimeoutExceedsMaxTimeoutSeconds() {
        Job job = Job.builder().executionTimeout(Long.valueOf(3000L)).executionTimeoutUnit(TemporalUnit.SECONDS).build();
        this.testUnsuccessfulValidation("Job executionTimeout configuration can not exceed the HttpRecipient max-timeout-in-millis", new ValidatorContext(job));
    }

    private void testUnsuccessfulValidation(String expectedError, ValidatorContext context) {
        Assertions.assertThatThrownBy(() -> this.validator.validate(this.recipient, context)).hasMessageStartingWith(expectedError);
    }
}

