/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.job.recipient.common.http;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

public class HTTPRequest {
    private final String url;
    private final HTTPMethod method;
    private final Map<String, String> headers;
    private final Map<String, String> queryParams;
    private final Object body;

    private HTTPRequest(String url, HTTPMethod method, Map<String, String> headers, Object body, Map<String, String> queryParams) {
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.body = body;
        this.queryParams = queryParams;
    }

    public String getUrl() {
        return this.url;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HTTPRequest)) {
            return false;
        }
        HTTPRequest that = (HTTPRequest)o;
        return Objects.equals(this.getUrl(), that.getUrl()) && this.getMethod() == that.getMethod() && Objects.equals(this.getHeaders(), that.getHeaders()) && Objects.equals(this.getQueryParams(), that.getQueryParams()) && Objects.equals(this.getBody(), that.getBody());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getUrl(), this.getMethod(), this.getHeaders(), this.getQueryParams(), this.getBody()});
    }

    public String toString() {
        return new StringJoiner(", ", HTTPRequest.class.getSimpleName() + "[", "]").add("url='" + this.url + "'").add("method=" + this.method).add("headers=" + this.headers).add("queryParams=" + this.queryParams).add("body='" + this.body + "'").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum HTTPMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH,
        OPTIONS,
        HEAD,
        TRACE;

    }

    public static class Builder {
        private String url;
        private HTTPMethod method;
        private Map<String, String> headers = new HashMap<String, String>();
        private Object body;
        private Map<String, String> queryParams = new HashMap<String, String>();

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            this.method = HTTPMethod.valueOf(method);
            return this;
        }

        public Builder method(HTTPMethod method) {
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        public Builder queryParams(Map<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder addQueryParam(String name, String value) {
            this.queryParams.put(name, value);
            return this;
        }

        public HTTPRequest build() {
            return new HTTPRequest(this.url, this.method, this.headers, this.body, this.queryParams);
        }
    }
}

