/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.awaitility.Awaitility;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.event.serialization.SerializationUtils;

public class TestUtils {
    public static final String CREATE_PATH_V2 = "/v2/jobs";
    public static Function<String, String> GET_JOB_V2_QUERY = jobId -> String.format("/v2/jobs/%s", jobId);

    private TestUtils() {
    }

    public static byte[] readFileContent(String classPathResource) throws Exception {
        URL url = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource(classPathResource), "Required test resource was not found in class path: " + classPathResource);
        Path path = Paths.get(url.toURI());
        return Files.readAllBytes(path);
    }

    public static Job createJobV2(Job job, ObjectMapper objectMapper) throws Exception {
        String body = objectMapper.writeValueAsString((Object)job);
        String response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(body).when().post(CREATE_PATH_V2, new Object[0])).then()).statusCode(200)).extract().body().asString();
        return (Job)objectMapper.readValue(response, Job.class);
    }

    public static Job createJobV2(Job job) throws Exception {
        return TestUtils.createJobV2(job, SerializationUtils.DEFAULT_OBJECT_MAPPER);
    }

    public static void assertJobHasFinishedV2(String jobId, long atMostTimeoutInSeconds) {
        Awaitility.await().atMost(atMostTimeoutInSeconds, TimeUnit.SECONDS).with().pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).get(GET_JOB_V2_QUERY.apply(jobId), new Object[0])).then()).statusCode(404));
    }
}

