/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.health.knative;

import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.health.knative.KSinkInjectionHealthCheck;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class KSinkInjectionHealthCheckTest {
    private KSinkInjectionHealthCheck healthCheck;
    @Mock
    private UnaryOperator<String> envReader;

    KSinkInjectionHealthCheckTest() {
    }

    @BeforeEach
    void setUp() {
        this.healthCheck = new KSinkInjectionHealthCheck(this.envReader);
    }

    @Test
    void callSuccessful() {
        ((UnaryOperator)Mockito.doReturn((Object)"http://localhost:8080").when(this.envReader)).apply("K_SINK");
        HealthCheckResponse response = this.healthCheck.call();
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)HealthCheckResponse.Status.UP);
    }

    @Test
    void callUnsuccessfulMissingEnvVar() {
        HealthCheckResponse response = this.healthCheck.call();
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)HealthCheckResponse.Status.DOWN);
    }

    @Test
    void callUnsuccessfulBadURL() {
        ((UnaryOperator)Mockito.doReturn((Object)"that's not a url").when(this.envReader)).apply("K_SINK");
        HealthCheckResponse response = this.healthCheck.call();
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)HealthCheckResponse.Status.DOWN);
    }

    @Test
    void callUnsuccessfulUnresolvableURL() {
        ((UnaryOperator)Mockito.doReturn((Object)"http://something.invalid").when(this.envReader)).apply("K_SINK");
        HealthCheckResponse response = this.healthCheck.call();
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)HealthCheckResponse.Status.DOWN);
    }
}

