/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.management;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.reactive.messaging.kafka.KafkaConnector;
import io.vertx.mutiny.core.TimeoutStream;
import io.vertx.mutiny.core.Vertx;
import java.time.OffsetDateTime;
import java.util.function.Function;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.management.JobServiceInstanceManager;
import org.kie.kogito.jobs.service.management.MessagingChangeEvent;
import org.kie.kogito.jobs.service.model.JobServiceManagementInfo;
import org.kie.kogito.jobs.service.repository.JobServiceManagementRepository;
import org.kie.kogito.jobs.service.repository.impl.DefaultJobServiceManagementRepository;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class JobServiceInstanceManagerTest {
    @InjectMocks
    @Spy
    JobServiceInstanceManager tested;
    @Spy
    Vertx vertx = Vertx.vertx();
    @Spy
    JobServiceManagementRepository repository = new DefaultJobServiceManagementRepository();
    @Mock
    KafkaConnector kafkaConnector;
    @Mock
    Event<MessagingChangeEvent> messagingChangeEventEvent;
    @Captor
    ArgumentCaptor<JobServiceManagementInfo> infoCaptor;
    @Mock
    ShutdownEvent shutdownEvent;
    @Mock
    StartupEvent startupEvent;

    @BeforeEach
    void setUp() {
        this.tested.heartbeatExpirationInSeconds = 1L;
        this.tested.leaderCheckIntervalInSeconds = 1L;
        this.tested.heardBeatIntervalInSeconds = 1L;
    }

    @Test
    void startup() {
        this.tested.startup(this.startupEvent);
        Assertions.assertThat((Object)this.tested.getCurrentInfo()).isNotNull();
        ((JobServiceInstanceManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).tryBecomeLeader((JobServiceManagementInfo)this.infoCaptor.capture(), (TimeoutStream)ArgumentMatchers.any(TimeoutStream.class), (TimeoutStream)ArgumentMatchers.any(TimeoutStream.class));
        Assertions.assertThat((Object)((JobServiceManagementInfo)this.infoCaptor.getValue())).isEqualTo((Object)this.tested.getCurrentInfo());
        Assertions.assertThat((Object)this.tested.getHeartbeat()).isNotNull();
        Assertions.assertThat((Object)this.tested.getCheckLeader()).isNotNull();
    }

    @Test
    void onShutdown() {
        this.tested.startup(this.startupEvent);
        this.tested.onShutdown(this.shutdownEvent);
        ((JobServiceInstanceManager)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.times((int)1))).release((JobServiceManagementInfo)this.infoCaptor.capture());
        Assertions.assertThat((Object)((JobServiceManagementInfo)this.infoCaptor.getValue())).isEqualTo((Object)this.tested.getCurrentInfo());
        ((JobServiceManagementRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).set(new JobServiceManagementInfo());
    }

    @Test
    void tryBecomeLeaderSuccess() {
        JobServiceManagementInfo info = new JobServiceManagementInfo("id", "token", OffsetDateTime.now());
        ArgumentCaptor updateFunction = ArgumentCaptor.forClass(Function.class);
        TimeoutStream checkLeader = this.vertx.timerStream(1L);
        TimeoutStream heartbeat = this.vertx.timerStream(1L);
        this.tested.tryBecomeLeader(info, checkLeader, heartbeat).await().indefinitely();
        ((JobServiceManagementRepository)Mockito.verify((Object)this.repository)).getAndUpdate(ArgumentMatchers.anyString(), (Function)updateFunction.capture());
        Assertions.assertThat((boolean)this.tested.isLeader()).isTrue();
    }

    @Test
    void tryBecomeLeaderFail() {
        JobServiceManagementInfo info = new JobServiceManagementInfo("id", "token", OffsetDateTime.now());
        JobServiceManagementInfo info2 = new JobServiceManagementInfo("id2", "token2", OffsetDateTime.now());
        this.repository.set(info).await().indefinitely();
        ArgumentCaptor updateFunction = ArgumentCaptor.forClass(Function.class);
        TimeoutStream checkLeader = this.vertx.timerStream(1L);
        TimeoutStream heartbeat = this.vertx.timerStream(1L);
        this.tested.tryBecomeLeader(info2, checkLeader, heartbeat).await().indefinitely();
        ((JobServiceManagementRepository)Mockito.verify((Object)this.repository)).getAndUpdate(ArgumentMatchers.anyString(), (Function)updateFunction.capture());
        Assertions.assertThat((boolean)this.tested.isLeader()).isFalse();
    }

    @Test
    void heartbeatNotLeader() {
        JobServiceManagementInfo info = new JobServiceManagementInfo("id", "token", OffsetDateTime.now());
        this.tested.heartbeat(info).await().indefinitely();
        ((JobServiceManagementRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).heartbeat(info);
    }

    @Test
    void heartbeatLeader() {
        this.tested.startup(this.startupEvent);
        this.tested.heartbeat(this.tested.getCurrentInfo()).await().indefinitely();
        ((JobServiceManagementRepository)Mockito.verify((Object)this.repository)).heartbeat(this.tested.getCurrentInfo());
    }
}

