/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

public abstract class BaseCallbackResource {
    public static final String CALLBACK_RESOURCE_PATH = "/test/callback/management/jobs";
    private static final Map<String, List<CallbackExecution>> EXECUTED_CALLBACKS = new HashMap<String, List<CallbackExecution>>();

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/timers/{timerId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeCallback(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="timerId") String timerId, @QueryParam(value="limit") @DefaultValue(value="0") Integer limit) {
        EXECUTED_CALLBACKS.computeIfAbsent(timerId, id -> new ArrayList()).add(new CallbackExecution(processId, processInstanceId, timerId, limit));
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="/executionsList/{timerId}")
    @Produces(value={"application/json"})
    public List<CallbackExecution> getExecutionsList(@PathParam(value="timerId") String timerId) {
        return EXECUTED_CALLBACKS.getOrDefault(timerId, new ArrayList());
    }

    @GET
    @Path(value="/executions/{timerId}")
    @Produces(value={"application/json"})
    public int getExecutions(@PathParam(value="timerId") String timerId) {
        return ((List)EXECUTED_CALLBACKS.getOrDefault(timerId, new ArrayList())).size();
    }

    public static class CallbackExecution {
        String processId;
        String processInstanceId;
        String timerId;
        int limit;

        public CallbackExecution(String processId, String processInstanceId, String timerId, int limit) {
            this.processId = processId;
            this.processInstanceId = processInstanceId;
            this.timerId = timerId;
            this.limit = limit;
        }
    }
}

