/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging;

import io.cloudevents.CloudEvent;
import io.quarkus.test.junit.QuarkusTest;
import java.net.URI;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.TestUtils;
import org.kie.kogito.jobs.service.messaging.CloudEventDeserializer;

@QuarkusTest
class CloudEventDeserializerTest {
    private static final String CLOUD_EVENT_RESOURCE = "org/kie/kogito/jobs/service/messaging/CloudEvent.json";

    CloudEventDeserializerTest() {
    }

    @Test
    void deserialize() throws Exception {
        CloudEventDeserializer deserializer = new CloudEventDeserializer();
        CloudEvent cloudEvent = (CloudEvent)deserializer.deserialize("topic", TestUtils.readFileContent(CLOUD_EVENT_RESOURCE));
        Assertions.assertThat((Object)cloudEvent).isNotNull();
        Assertions.assertThat((Comparable)cloudEvent.getSpecVersion()).hasToString("1.0");
        Assertions.assertThat((String)cloudEvent.getId()).isEqualTo("eventId");
        Assertions.assertThat((URI)cloudEvent.getSource()).isEqualTo((Object)URI.create("http://event_source"));
        Assertions.assertThat((String)cloudEvent.getType()).isEqualTo("eventType");
        Assertions.assertThat((URI)cloudEvent.getDataSchema()).isEqualTo((Object)URI.create("http://event_data_schema/schema.json"));
        Assertions.assertThat((String)cloudEvent.getDataContentType()).isEqualTo("application/json; charset=utf-8");
        Assertions.assertThat((String)cloudEvent.getSubject()).isEqualTo("eventSubject");
        Assertions.assertThat((Object)cloudEvent.getData()).isNotNull();
        Assertions.assertThat((byte[])cloudEvent.getData().toBytes()).isEqualTo((Object)"{\"dataField1\":\"eventData1\",\"dataField2\":\"eventData2\"}".getBytes());
        Assertions.assertThat((Collection)cloudEvent.getExtensionNames()).containsExactlyInAnyOrder((Object[])new String[]{"extension1", "extension2"});
        Assertions.assertThat((Object)cloudEvent.getExtension("extension1")).isEqualTo((Object)"eventExtension1");
        Assertions.assertThat((Object)cloudEvent.getExtension("extension2")).isEqualTo((Object)"eventExtension2");
    }
}

