/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2;

import io.restassured.response.ValidatableResponse;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.jobs.service.resource.CommonBaseJobResourceIT;

public abstract class BaseJobResourceV2IT
extends CommonBaseJobResourceIT {
    public static final String JOB_ID = "JOB_ID";
    public static final OffsetDateTime OVERDUE_START_TIME = OffsetDateTime.parse("2023-01-24T15:20:25.001+01:00");

    @Override
    protected String getCreatePath() {
        return "/v2/jobs";
    }

    @Override
    protected String getGetJobQuery(String jobId) {
        return String.format("/v2/jobs/%s", jobId);
    }

    @Test
    void createOverdueJob() throws Exception {
        this.createOverdueJob(JOB_ID);
    }

    @ParameterizedTest
    @MethodSource(value={"createOverdueJobMultipleParams"})
    void createOverdueJobMultiple(String jobId) throws Exception {
        this.createOverdueJob(jobId);
    }

    protected static List<String> createOverdueJobMultipleParams() {
        return Arrays.asList("JOB_ID_R1", "JOB_ID_R2", "JOB_ID_R3", "JOB_ID_R4", "JOB_ID_R5", "JOB_ID_R6", "JOB_ID_R7", "JOB_ID_R8", "JOB_ID_R9", "JOB_ID_R10");
    }

    protected void createOverdueJob(String jobId) throws Exception {
        this.scheduler.setForceExecuteExpiredJobs(true);
        Job job = Job.builder().id(jobId).correlationId(jobId).schedule((Schedule)TimerSchedule.builder().startTime(OVERDUE_START_TIME).build()).recipient((Recipient)HttpRecipient.builder().forStringPayload().url(this.getCallbackEndpoint()).build()).build();
        Job response = this.createJob(job);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((String)response.getId()).isEqualTo(jobId);
        this.assertJobHasFinished(jobId, 10L);
    }

    protected Job createJob(Job job) throws Exception {
        String response = ((ValidatableResponse)this.create(this.objectMapper.writeValueAsString((Object)job)).statusCode(200)).extract().body().asString();
        return (Job)this.objectMapper.readValue(response, Job.class);
    }

    @Test
    public void testCreateGetAndDelete() throws Exception {
        Job job = this.buildJob(JOB_ID, OffsetDateTime.now().plusMinutes(10L));
        Job created = this.createJob(job);
        Assertions.assertThat((Object)created).isNotNull();
        Assertions.assertThat((String)created.getId()).isEqualTo(job.getId());
        Assertions.assertThat((Comparable)created.getState()).isNotNull();
        Assertions.assertThat((Comparable)job.getState()).isNull();
        Job getJob = this.getJob(created.getId(), Job.class);
        Assertions.assertThat((String)getJob.getId()).isEqualTo(created.getId());
        this.deleteJob(created.getId());
        this.getJob(created.getId(), Job.class, 404);
    }

    private Job buildJob(String jobId, OffsetDateTime time) {
        return Job.builder().id(jobId).correlationId(jobId).schedule((Schedule)TimerSchedule.builder().startTime(time).build()).recipient((Recipient)HttpRecipient.builder().forStringPayload().url(this.getCallbackEndpoint()).build()).build();
    }
}

