/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import org.kie.kogito.jobs.service.resource.v2.http.recipient.BaseHttpRecipientPayloadTypesIT;

public class ExternalResourcesMock
implements QuarkusTestResourceLifecycleManager {
    private WireMockServer wireMockServer;
    private String baseUrl;
    public static final String EXTERNAL_RESOURCES_MOCK_URL = "external-resources-mock.url";

    public Map<String, String> start() {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort());
        this.wireMockServer.start();
        WireMock.configureFor((int)this.wireMockServer.port());
        this.setUpBaseHttpRecipientPayloadTypesIT();
        this.baseUrl = this.wireMockServer.baseUrl();
        return Collections.singletonMap(EXTERNAL_RESOURCES_MOCK_URL, this.baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void stop() {
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    public void inject(Object testInstance) {
        if (testInstance instanceof BaseHttpRecipientPayloadTypesIT) {
            ((BaseHttpRecipientPayloadTypesIT)testInstance).setExternalResourcesServer(this.wireMockServer);
        }
    }

    private void setUpBaseHttpRecipientPayloadTypesIT() {
        WireMock.stubFor((MappingBuilder)WireMock.post((String)ExternalResourcesMock.addQueryParams("/external-resource/http-recipient-json-payload-data")).withHeader("Content-Type", WireMock.equalTo((String)"application/json")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withRequestBody((ContentPattern)WireMock.equalToJson((String)"{\"PROPERTY_1\" : \"PROPERTY_1_VALUE\"}")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)ExternalResourcesMock.addQueryParams("/external-resource/http-recipient-string-payload-data")).withHeader("Content-Type", WireMock.equalTo((String)"text/plain")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withRequestBody((ContentPattern)WireMock.equalTo((String)"Plain text sent to the recipient")).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
        WireMock.stubFor((MappingBuilder)WireMock.post((String)ExternalResourcesMock.addQueryParams("/external-resource/http-recipient-binary-payload-data")).withHeader("Content-Type", WireMock.equalTo((String)"application/octet-stream")).withHeader("HTTP_HEADER_1", WireMock.equalTo((String)"HTTP_HEADER_1_VALUE")).withHeader("HTTP_HEADER_2", WireMock.equalTo((String)"HTTP_HEADER_2_VALUE")).withRequestBody((ContentPattern)new BinaryEqualToPattern(BaseHttpRecipientPayloadTypesIT.BINARY_VALUE)).willReturn(WireMock.aResponse().withHeader("Content-Type", new String[]{"application/json"}).withBody("{}")));
    }

    private static String addQueryParams(String url) {
        return String.format("%s?%s=%s", url, "HTTP_QUERY_PARAM_1", "HTTP_QUERY_PARAM_1_VALUE");
    }
}

