/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.resource.v2.http.recipient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import java.time.OffsetDateTime;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.TestUtils;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.Recipient;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientBinaryPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientJsonPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.jobs.service.health.HealthCheckUtils;

public abstract class BaseHttpRecipientPayloadTypesIT {
    public static final String EXTERNAL_RESOURCE_FOR_JSON_PAYLOAD = "/external-resource/http-recipient-json-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_STRING_PAYLOAD = "/external-resource/http-recipient-string-payload-data";
    public static final String EXTERNAL_RESOURCE_FOR_BINARY_PAYLOAD = "/external-resource/http-recipient-binary-payload-data";
    public static final String JSON_JOB_ID = "JSON_JOB_ID";
    public static final String STRING_JOB_ID = "STRING_JOB_ID";
    public static final String BINARY_JOB_ID = "BINARY_JOB_ID";
    public static final String HTTP_HEADER_1 = "HTTP_HEADER_1";
    public static final String HTTP_HEADER_1_VALUE = "HTTP_HEADER_1_VALUE";
    public static final String HTTP_HEADER_2 = "HTTP_HEADER_2";
    public static final String HTTP_HEADER_2_VALUE = "HTTP_HEADER_2_VALUE";
    public static final String HTTP_QUERY_PARAM_1 = "HTTP_QUERY_PARAM_1";
    public static final String HTTP_QUERY_PARAM_1_VALUE = "HTTP_QUERY_PARAM_1_VALUE";
    public static final String PROPERTY_1 = "PROPERTY_1";
    public static final String PROPERTY_1_VALUE = "PROPERTY_1_VALUE";
    public static final String TEXT_PLAIN_VALUE = "Plain text sent to the recipient";
    public static final byte[] BINARY_VALUE = "Arbitrary bytes sent to the recipient".getBytes();
    protected WireMockServer externalResourcesServer;
    protected String externalResourcesServerURL;
    @Inject
    protected ObjectMapper objectMapper;

    @BeforeEach
    void setUp() {
        HealthCheckUtils.awaitReadyHealthCheck(1, TimeUnit.MINUTES);
    }

    public void setExternalResourcesServer(WireMockServer externalResourcesServer) {
        this.externalResourcesServer = externalResourcesServer;
        this.externalResourcesServerURL = externalResourcesServer.baseUrl();
    }

    @Test
    void httpRecipientWithJsonPayloadData() throws Exception {
        ObjectNode payload = this.objectMapper.createObjectNode().put(PROPERTY_1, PROPERTY_1_VALUE);
        HttpRecipient httpRecipient = HttpRecipient.builder().forJsonPayload().payload((HttpRecipientPayloadData)HttpRecipientJsonPayloadData.from((JsonNode)payload)).header("Content-Type", "application/json").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_JSON_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesIT.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(JSON_JOB_ID).correlationId(JSON_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    @Test
    void httpRecipientWithStringPayloadData() throws Exception {
        HttpRecipient httpRecipient = HttpRecipient.builder().forStringPayload().payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)TEXT_PLAIN_VALUE)).header("Content-Type", "text/plain").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_STRING_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesIT.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(STRING_JOB_ID).correlationId(STRING_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    @Test
    void httpRecipientWithBinaryPayloadData() throws Exception {
        HttpRecipient httpRecipient = HttpRecipient.builder().forBinaryPayload().payload((HttpRecipientPayloadData)HttpRecipientBinaryPayloadData.from((byte[])BINARY_VALUE)).header("Content-Type", "application/octet-stream").url(this.externalResourcesServerURL + EXTERNAL_RESOURCE_FOR_BINARY_PAYLOAD).build();
        BaseHttpRecipientPayloadTypesIT.applyCommonValues(httpRecipient);
        Job job = Job.builder().id(BINARY_JOB_ID).correlationId(BINARY_JOB_ID).recipient((Recipient)httpRecipient).schedule((Schedule)TimerSchedule.builder().startTime(OffsetDateTime.now().plusSeconds(3L)).build()).build();
        this.executeHttpRecipientJob(job);
    }

    private void executeHttpRecipientJob(Job job) throws Exception {
        Job createdJob = TestUtils.createJobV2(job);
        Assertions.assertThat((Object)createdJob).isNotNull();
        TestUtils.assertJobHasFinishedV2(job.getId(), 60L);
    }

    private static void applyCommonValues(HttpRecipient<?> recipient) {
        recipient.addHeader(HTTP_HEADER_1, HTTP_HEADER_1_VALUE);
        recipient.addHeader(HTTP_HEADER_2, HTTP_HEADER_2_VALUE);
        recipient.addQueryParam(HTTP_QUERY_PARAM_1, HTTP_QUERY_PARAM_1_VALUE);
        recipient.setMethod("POST");
    }
}

