/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.stream;

import io.quarkus.runtime.StartupEvent;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.smallrye.common.annotation.Identifier;
import io.vertx.mutiny.core.Vertx;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.stream.KafkaConfiguration;
import org.kie.kogito.testcontainers.quarkus.KafkaQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=KafkaQuarkusTestResource.class, restrictToAnnotatedClass=true)
class KafkaConfigurationIT {
    private KafkaConfiguration tested;
    private static final String TOPIC = UUID.randomUUID().toString();
    @Inject
    Vertx vertx;
    @Inject
    @Identifier(value="default-kafka-broker")
    Instance<Map<String, Object>> defaultKafkaConfiguration;

    KafkaConfigurationIT() {
    }

    @Test
    void topicConfiguration() {
        this.tested = new KafkaConfiguration(this.defaultKafkaConfiguration, this.vertx, Optional.of(Boolean.TRUE), TOPIC);
        Assertions.assertThat((Object)this.tested.getAdminClient()).isNull();
        this.tested.topicConfiguration(new StartupEvent());
        Assertions.assertThat((Object)this.tested.getAdminClient()).isNotNull();
        Awaitility.await().atMost(Duration.ofSeconds(4L)).untilAsserted(() -> Assertions.assertThat((Collection)this.tested.getAdminClient().listTopicsAndAwait()).contains((Object[])new String[]{TOPIC}));
        this.tested.getAdminClient().deleteTopicsAndAwait(Arrays.asList(TOPIC));
    }

    @Test
    void topicConfigurationDisabledEvents() {
        this.tested = new KafkaConfiguration(this.defaultKafkaConfiguration, this.vertx, Optional.of(Boolean.FALSE), TOPIC);
        Assertions.assertThat((Object)this.tested.getAdminClient()).isNull();
        this.tested.topicConfiguration(new StartupEvent());
        Assertions.assertThat((Object)this.tested.getAdminClient()).isNull();
    }
}

