/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.validator;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientPayloadData;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipientStringPayloadData;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.validator.JobDetailsValidator;
import org.kie.kogito.jobs.service.validator.RecipientInstanceValidator;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

class JobDetailsValidatorTest {
    private static final String CALLBACK_ENDPOINT = "http://localhost:8080/callback";
    private static final String ID = "id";
    private JobDetailsValidator jobDetailsValidator;
    private Recipient recipient;

    JobDetailsValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobDetailsValidator = new JobDetailsValidator(new RecipientInstanceValidator(null));
        this.recipient = new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient)HttpRecipient.builder().forStringPayload().url(CALLBACK_ENDPOINT).payload((HttpRecipientPayloadData)HttpRecipientStringPayloadData.from((String)"{\"name\":\"Arthur\"}")).build());
    }

    @Test
    void testValidateSuccess() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).recipient(this.recipient).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThat((Object)this.jobDetailsValidator.validateToCreate(job)).isEqualTo((Object)job);
    }

    @Test
    void testValidateMissingId() {
        JobDetails job = new JobDetailsBuilder().correlationId(ID).recipient(this.recipient).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToCreate(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingPayload() {
        JobDetails job = new JobDetailsBuilder().recipient(this.recipient).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToCreate(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingRecipientEndpoint() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToCreate(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingRecipient() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).recipient(null).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToCreate(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateMissingTrigger() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).recipient(this.recipient).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToCreate(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateToMergeSuccess() {
        JobDetails job = new JobDetailsBuilder().trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThat((Object)this.jobDetailsValidator.validateToMerge(job)).isEqualTo((Object)job);
    }

    @Test
    void testValidateToMergeWithId() {
        JobDetails job = new JobDetailsBuilder().id(ID).correlationId(ID).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToMerge(job)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testValidateToMergeWithRecipient() {
        JobDetails job = new JobDetailsBuilder().recipient(this.recipient).trigger((Trigger)new PointInTimeTrigger()).build();
        Assertions.assertThatThrownBy(() -> this.jobDetailsValidator.validateToMerge(job)).isInstanceOf(IllegalArgumentException.class);
    }
}

