/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.adapter;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.api.recipient.http.HttpRecipient;
import org.kie.kogito.jobs.service.model.JobDetails;
import org.kie.kogito.jobs.service.model.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.Recipient;
import org.kie.kogito.jobs.service.model.RecipientInstance;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

public class ScheduledJobAdapter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ScheduledJobAdapter() {
    }

    public static ScheduledJob of(JobDetails jobDetails) {
        ProcessPayload payload = Optional.ofNullable(jobDetails.getRecipient()).map(Recipient::getRecipient).filter(HttpRecipient.class::isInstance).map(HttpRecipient.class::cast).map(httpRecipient -> {
            String processInstanceId = httpRecipient.getHeader("processInstanceId");
            String rootProcessInstanceId = httpRecipient.getHeader("rootProcessInstanceId");
            String processId = httpRecipient.getHeader("processId");
            String rootProcessId = httpRecipient.getHeader("rootProcessId");
            String nodeInstanceId = httpRecipient.getHeader("nodeInstanceId");
            return new ProcessPayload(processInstanceId, rootProcessInstanceId, processId, rootProcessId, nodeInstanceId);
        }).filter(processPayload -> Objects.nonNull(processPayload.processInstanceId)).orElse(new ProcessPayload());
        return ScheduledJob.builder().job(new JobBuilder().id(jobDetails.getId()).priority(jobDetails.getPriority()).expirationTime((ZonedDateTime)Optional.ofNullable(jobDetails.getTrigger()).map(Trigger::hasNextFireTime).map(DateUtil::fromDate).orElse(null)).callbackEndpoint((String)Optional.ofNullable(jobDetails.getRecipient()).map(Recipient::getRecipient).filter(HttpRecipient.class::isInstance).map(HttpRecipient.class::cast).map(HttpRecipient::getUrl).orElse(null)).repeatLimit(ScheduledJobAdapter.extractRepeatLimit(jobDetails.getTrigger())).repeatInterval(ScheduledJobAdapter.extractRepeatInterval(jobDetails.getTrigger())).rootProcessId(payload.getRootProcessId()).rootProcessInstanceId(payload.getRootProcessInstanceId()).processId(payload.getProcessId()).processInstanceId(payload.getProcessInstanceId()).nodeInstanceId(payload.getNodeInstanceId()).build()).scheduledId(jobDetails.getScheduledId()).status(jobDetails.getStatus()).executionCounter(jobDetails.getExecutionCounter()).retries(jobDetails.getRetries()).lastUpdate(jobDetails.getLastUpdate()).build();
    }

    public static JobDetails to(ScheduledJob scheduledJob) {
        return new JobDetailsBuilder().id(scheduledJob.getId()).correlationId(scheduledJob.getId()).executionCounter(scheduledJob.getExecutionCounter()).lastUpdate(scheduledJob.getLastUpdate()).recipient(ScheduledJobAdapter.recipientAdapter(scheduledJob)).retries(scheduledJob.getRetries()).scheduledId(scheduledJob.getScheduledId()).status(scheduledJob.getStatus()).trigger(ScheduledJobAdapter.triggerAdapter(scheduledJob)).priority(scheduledJob.getPriority()).build();
    }

    private static RecipientInstance recipientAdapter(ScheduledJob scheduledJob) {
        return Optional.ofNullable(scheduledJob.getCallbackEndpoint()).map(url -> new RecipientInstance((org.kie.kogito.jobs.service.api.Recipient<?>)HttpRecipient.builder().forStringPayload().url(url).header("processId", scheduledJob.getProcessId()).header("processInstanceId", scheduledJob.getProcessInstanceId()).header("rootProcessInstanceId", scheduledJob.getRootProcessInstanceId()).header("rootProcessId", scheduledJob.getRootProcessId()).header("nodeInstanceId", scheduledJob.getNodeInstanceId()).build())).orElse(null);
    }

    public static Trigger triggerAdapter(ScheduledJob scheduledJob) {
        if (scheduledJob.getExpirationTime() == null) {
            return null;
        }
        Date startTime = DateUtil.toDate(scheduledJob.getExpirationTime().toOffsetDateTime());
        String zoneId = scheduledJob.getExpirationTime().toOffsetDateTime().getOffset().getId();
        long period = 0L;
        ChronoUnit periodUnit = ChronoUnit.MILLIS;
        int repeatCount = 0;
        if (scheduledJob.hasInterval().isPresent()) {
            if (scheduledJob.getRepeatLimit() != null && scheduledJob.getRepeatLimit() > 1) {
                repeatCount = scheduledJob.getRepeatLimit() - 1;
            }
            period = repeatCount != 0 ? scheduledJob.hasInterval().get() : 0L;
        }
        return new SimpleTimerTrigger(startTime, period, periodUnit, repeatCount, zoneId);
    }

    private static Integer extractRepeatLimit(Trigger trigger) {
        if (trigger instanceof SimpleTimerTrigger) {
            return ((SimpleTimerTrigger)trigger).getRepeatCount();
        }
        if (trigger instanceof IntervalTrigger) {
            return ((IntervalTrigger)trigger).getRepeatLimit();
        }
        return null;
    }

    private static Long extractRepeatInterval(Trigger trigger) {
        if (trigger instanceof SimpleTimerTrigger) {
            SimpleTimerTrigger simpleTimerTrigger = (SimpleTimerTrigger)trigger;
            return simpleTimerTrigger.getPeriodUnit().getDuration().multipliedBy(simpleTimerTrigger.getPeriod()).toMillis();
        }
        if (trigger instanceof IntervalTrigger) {
            return ((IntervalTrigger)trigger).getPeriod();
        }
        return null;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public static final class ProcessPayload {
        private String processInstanceId;
        private String rootProcessInstanceId;
        private String processId;
        private String rootProcessId;
        private String nodeInstanceId;

        private ProcessPayload() {
        }

        public ProcessPayload(String processInstanceId, String rootProcessInstanceId, String processId, String rootProcessId, String nodeInstanceId) {
            this.processInstanceId = processInstanceId;
            this.rootProcessInstanceId = rootProcessInstanceId;
            this.processId = processId;
            this.rootProcessId = rootProcessId;
            this.nodeInstanceId = nodeInstanceId;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public String getRootProcessInstanceId() {
            return this.rootProcessInstanceId;
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getRootProcessId() {
            return this.rootProcessId;
        }

        public String getNodeInstanceId() {
            return this.nodeInstanceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessPayload that = (ProcessPayload)o;
            return Objects.equals(this.processInstanceId, that.processInstanceId) && Objects.equals(this.rootProcessInstanceId, that.rootProcessInstanceId) && Objects.equals(this.processId, that.processId) && Objects.equals(this.rootProcessId, that.rootProcessId) && Objects.equals(this.nodeInstanceId, that.nodeInstanceId);
        }

        public int hashCode() {
            return Objects.hash(this.processInstanceId, this.rootProcessInstanceId, this.processId, this.rootProcessId, this.nodeInstanceId);
        }
    }
}

