/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.adapter;

import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.jobs.service.adapter.JobDetailsAdapter;
import org.kie.kogito.jobs.service.api.Schedule;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.api.schedule.timer.TimerSchedule;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.kie.kogito.timer.impl.SimpleTimerTrigger;

class JobDetailsAdapterTest {
    private static final OffsetDateTime TIMER_SCHEDULE_START_TIME = OffsetDateTime.parse("2023-03-06T14:00:00.000+01:00");

    JobDetailsAdapterTest() {
    }

    @Test
    void triggerFromScheduleWithRepetitions() {
        TimerSchedule schedule = TimerSchedule.builder().startTime(TIMER_SCHEDULE_START_TIME).delay(Long.valueOf(5L)).delayUnit(TemporalUnit.SECONDS).repeatCount(Integer.valueOf(2)).build();
        Trigger trigger = JobDetailsAdapter.ScheduleAdapter.from((Schedule)schedule);
        Assertions.assertThat((Object)trigger).isExactlyInstanceOf(SimpleTimerTrigger.class);
        SimpleTimerTrigger simpleTimerTrigger = (SimpleTimerTrigger)trigger;
        Assertions.assertThat((int)simpleTimerTrigger.getRepeatCount()).isEqualTo((Object)schedule.getRepeatCount());
        Assertions.assertThat((long)simpleTimerTrigger.getPeriod()).isEqualTo(5L);
        Assertions.assertThat((Comparable)((Object)simpleTimerTrigger.getPeriodUnit())).isEqualTo((Object)ChronoUnit.SECONDS);
        Assertions.assertThat((Date)simpleTimerTrigger.getEndTime()).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)simpleTimerTrigger.getZoneId()).isNotNull()).hasToString("+01:00");
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNotNull();
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo(TIMER_SCHEDULE_START_TIME.toInstant());
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNotNull();
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo(TIMER_SCHEDULE_START_TIME.plus(5L, ChronoUnit.SECONDS).toInstant());
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNotNull();
        Assertions.assertThat((Date)trigger.nextFireTime()).isEqualTo(TIMER_SCHEDULE_START_TIME.plus(10L, ChronoUnit.SECONDS).toInstant());
        Assertions.assertThat((int)simpleTimerTrigger.getCurrentRepeatCount()).isEqualTo(2);
        Assertions.assertThat((Date)trigger.hasNextFireTime()).isNull();
    }

    @Test
    void triggerFromScheduleWithNoRepetitions() {
        TimerSchedule schedule = TimerSchedule.builder().startTime(TIMER_SCHEDULE_START_TIME).repeatCount(Integer.valueOf(0)).build();
        Trigger trigger = JobDetailsAdapter.ScheduleAdapter.from((Schedule)schedule);
        Assertions.assertThat((Object)trigger).isExactlyInstanceOf(SimpleTimerTrigger.class);
        SimpleTimerTrigger simpleTimerTrigger = (SimpleTimerTrigger)trigger;
        Assertions.assertThat((Date)simpleTimerTrigger.hasNextFireTime()).isEqualTo(TIMER_SCHEDULE_START_TIME.toInstant());
        Assertions.assertThat((Date)simpleTimerTrigger.nextFireTime()).isEqualTo(TIMER_SCHEDULE_START_TIME.toInstant());
        Assertions.assertThat((int)simpleTimerTrigger.getCurrentRepeatCount()).isZero();
        Assertions.assertThat((Date)simpleTimerTrigger.hasNextFireTime()).isNull();
    }

    @Test
    void toScheduleFromIntervalTrigger() {
        IntervalTrigger trigger = new IntervalTrigger(0L, Date.from(TIMER_SCHEDULE_START_TIME.toInstant()), null, 4, 0L, 5000L, null, null);
        Schedule schedule = JobDetailsAdapter.ScheduleAdapter.toSchedule((Trigger)trigger);
        Assertions.assertThat((Object)schedule).isExactlyInstanceOf(TimerSchedule.class);
        TimerSchedule timerSchedule = (TimerSchedule)schedule;
        Assertions.assertThat((OffsetDateTime)timerSchedule.getStartTime()).isEqualTo((Object)TIMER_SCHEDULE_START_TIME);
        Assertions.assertThat((Long)timerSchedule.getDelay()).isEqualTo(5000L);
        Assertions.assertThat((Integer)timerSchedule.getRepeatCount()).isEqualTo(3);
        Assertions.assertThat((Comparable)timerSchedule.getDelayUnit()).isEqualTo((Object)TemporalUnit.MILLIS);
    }

    @Test
    void toScheduleFromPointInTimeTrigger() {
        PointInTimeTrigger trigger = new PointInTimeTrigger(Date.from(TIMER_SCHEDULE_START_TIME.toInstant()).getTime(), null, null);
        Schedule schedule = JobDetailsAdapter.ScheduleAdapter.toSchedule((Trigger)trigger);
        Assertions.assertThat((Object)schedule).isExactlyInstanceOf(TimerSchedule.class);
        TimerSchedule timerSchedule = (TimerSchedule)schedule;
        Assertions.assertThat((OffsetDateTime)timerSchedule.getStartTime()).isEqualTo((Object)TIMER_SCHEDULE_START_TIME);
        Assertions.assertThat((Integer)timerSchedule.getRepeatCount()).isZero();
        Assertions.assertThat((Long)timerSchedule.getDelay()).isZero();
        Assertions.assertThat((Comparable)timerSchedule.getDelayUnit()).isEqualTo((Object)TemporalUnit.MILLIS);
    }

    @Test
    void toScheduleFromSimpleTimerTrigger() {
        SimpleTimerTrigger trigger = new SimpleTimerTrigger(Date.from(TIMER_SCHEDULE_START_TIME.toInstant()), 5L, ChronoUnit.HOURS, 8, TIMER_SCHEDULE_START_TIME.getOffset().getId());
        Schedule schedule = JobDetailsAdapter.ScheduleAdapter.toSchedule((Trigger)trigger);
        Assertions.assertThat((Object)schedule).isExactlyInstanceOf(TimerSchedule.class);
        TimerSchedule timerSchedule = (TimerSchedule)schedule;
        Assertions.assertThat((OffsetDateTime)timerSchedule.getStartTime()).isEqualTo((Object)TIMER_SCHEDULE_START_TIME);
        Assertions.assertThat((Integer)timerSchedule.getRepeatCount()).isEqualTo(8);
        Assertions.assertThat((Long)timerSchedule.getDelay()).isEqualTo(5L);
        Assertions.assertThat((Comparable)timerSchedule.getDelayUnit()).isEqualTo((Object)TemporalUnit.HOURS);
    }

    @ParameterizedTest
    @MethodSource(value={"toChronoUnitParams"})
    void toChronoUnit(TemporalUnit temporalUnit, ChronoUnit expectedChronoUnit) {
        Assertions.assertThat((Comparable)((Object)JobDetailsAdapter.TemporalUnitAdapter.toChronoUnit((TemporalUnit)temporalUnit))).isEqualTo((Object)expectedChronoUnit);
    }

    private static Stream<Arguments> toChronoUnitParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{TemporalUnit.MILLIS, ChronoUnit.MILLIS}), Arguments.of((Object[])new Object[]{TemporalUnit.SECONDS, ChronoUnit.SECONDS}), Arguments.of((Object[])new Object[]{TemporalUnit.MINUTES, ChronoUnit.MINUTES}), Arguments.of((Object[])new Object[]{TemporalUnit.HOURS, ChronoUnit.HOURS}), Arguments.of((Object[])new Object[]{TemporalUnit.DAYS, ChronoUnit.DAYS}));
    }

    @ParameterizedTest
    @MethodSource(value={"fromChronoUnitParams"})
    void fromChronoUnit(ChronoUnit chronoUnit, TemporalUnit expectedTemporalUnit) {
        Assertions.assertThat((Comparable)JobDetailsAdapter.TemporalUnitAdapter.fromChronoUnit((ChronoUnit)chronoUnit)).isEqualTo((Object)expectedTemporalUnit);
    }

    private static Stream<Arguments> fromChronoUnitParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{ChronoUnit.MILLIS, TemporalUnit.MILLIS}), Arguments.of((Object[])new Object[]{ChronoUnit.SECONDS, TemporalUnit.SECONDS}), Arguments.of((Object[])new Object[]{ChronoUnit.MINUTES, TemporalUnit.MINUTES}), Arguments.of((Object[])new Object[]{ChronoUnit.HOURS, TemporalUnit.HOURS}), Arguments.of((Object[])new Object[]{ChronoUnit.DAYS, TemporalUnit.DAYS}));
    }
}

