/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.utils;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.api.Job;
import org.kie.kogito.jobs.service.api.TemporalUnit;
import org.kie.kogito.jobs.service.utils.ModelUtil;

class ModelUtilTest {
    private Job job = Job.builder().build();

    ModelUtilTest() {
    }

    @Test
    void getExecutionTimeoutInMillisNoValue() {
        Assertions.assertThat((Long)ModelUtil.getExecutionTimeoutInMillis((Job)this.job)).isNull();
    }

    @Test
    void getExecutionTimeoutInMillisWithValue() {
        this.job.setExecutionTimeout(Long.valueOf(10L));
        Assertions.assertThat((Long)ModelUtil.getExecutionTimeoutInMillis((Job)this.job)).isEqualTo(10L);
    }

    @Test
    void getExecutionTimeoutInMillisWithValueAndUnit() {
        this.job.setExecutionTimeout(Long.valueOf(5L));
        this.job.setExecutionTimeoutUnit(TemporalUnit.MINUTES);
        Assertions.assertThat((Long)ModelUtil.getExecutionTimeoutInMillis((Job)this.job)).isEqualTo(300000L);
    }
}

