/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.messaging.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.http.vertx.VertxMessageFactory;
import io.quarkus.reactivemessaging.http.runtime.IncomingHttpMetadata;
import io.smallrye.reactive.messaging.MessageConverter;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CloudEventConverter
implements MessageConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventConverter.class);

    public boolean canConvert(Message<?> message, Type type) {
        return message.getMetadata(IncomingHttpMetadata.class).isPresent() && message.getPayload() instanceof Buffer && type == CloudEvent.class;
    }

    public Message<?> convert(Message<?> message, Type type) {
        LOGGER.debug("convert: message, {}, type: {}, metadata: {}, payload: {}", new Object[]{message, type, message.getMetadata(), message.getPayload()});
        IncomingHttpMetadata httpMetadata = (IncomingHttpMetadata)message.getMetadata(IncomingHttpMetadata.class).orElseThrow(() -> new IllegalStateException("No http metadata"));
        MultiMap httpHeaders = httpMetadata.getHeaders();
        LOGGER.debug("httpHeaders: {}", (Object)httpHeaders);
        Buffer buffer = (Buffer)message.getPayload();
        MessageReader messageReader = VertxMessageFactory.createReader((MultiMap)httpHeaders, (Buffer)buffer);
        CloudEvent cloudEvent = messageReader.toEvent();
        return message.withPayload((Object)cloudEvent);
    }
}

