/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql;

import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.pgclient.PgPool;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.Tuple;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.jobs.service.model.JobServiceManagementInfo;
import org.kie.kogito.jobs.service.repository.JobServiceManagementRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class PostgreSqlJobServiceManagementRepository
implements JobServiceManagementRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSqlJobServiceManagementRepository.class);
    private PgPool client;

    @Inject
    public PostgreSqlJobServiceManagementRepository(PgPool client) {
        this.client = client;
    }

    public Uni<JobServiceManagementInfo> getAndUpdate(String id, Function<JobServiceManagementInfo, JobServiceManagementInfo> computeUpdate) {
        LOGGER.info("get {}", (Object)id);
        return this.client.withTransaction(conn -> conn.preparedQuery("SELECT id, token, last_heartbeat FROM job_service_management WHERE id = $1 FOR UPDATE ").execute(Tuple.of((Object)id)).onItem().transform(RowSet::iterator).onItem().transform(iterator -> iterator.hasNext() ? this.from((Row)iterator.next()) : null).onItem().invoke(r -> LOGGER.info("got {}", r)).onItem().transformToUni(r -> this.update((SqlClient)conn, (JobServiceManagementInfo)computeUpdate.apply((JobServiceManagementInfo)r))));
    }

    JobServiceManagementInfo from(Row row) {
        return new JobServiceManagementInfo(row.getString("id"), row.getString("token"), row.getOffsetDateTime("last_heartbeat"));
    }

    public Uni<JobServiceManagementInfo> set(JobServiceManagementInfo info) {
        LOGGER.info("set {}", (Object)info);
        return this.update((SqlClient)this.client, info);
    }

    private Uni<JobServiceManagementInfo> update(SqlClient conn, JobServiceManagementInfo info) {
        if (Objects.isNull(info)) {
            return Uni.createFrom().nullItem();
        }
        return conn.preparedQuery("INSERT INTO job_service_management (id, token, last_heartbeat) VALUES ($1, $2, $3) ON CONFLICT (id) DO UPDATE SET token = $2, last_heartbeat = $3 RETURNING id, token, last_heartbeat").execute(Tuple.tuple(Stream.of(info.getId(), info.getToken(), info.getLastHeartbeat()).collect(Collectors.toList()))).onItem().transform(RowSet::iterator).onItem().transform(iterator -> iterator.hasNext() ? this.from((Row)iterator.next()) : null);
    }

    public Uni<JobServiceManagementInfo> heartbeat(JobServiceManagementInfo info) {
        return this.client.withTransaction(conn -> conn.preparedQuery("UPDATE job_service_management SET last_heartbeat = now() WHERE id = $1 AND token = $2 RETURNING id, token, last_heartbeat").execute(Tuple.of((Object)info.getId(), (Object)info.getToken())).onItem().transform(RowSet::iterator).onItem().transform(iterator -> iterator.hasNext() ? this.from((Row)iterator.next()) : null).onItem().invoke(r -> LOGGER.debug("Heartbeat {}", r)));
    }
}

