/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql.marshaller;

import io.vertx.core.json.JsonObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.repository.postgresql.marshaller.RecipientMarshaller;

class RecipientMarshallerTest {
    RecipientMarshaller marshaller = new RecipientMarshaller();

    RecipientMarshallerTest() {
    }

    @Test
    void marshall() {
        Recipient.HTTPRecipient recipient = new Recipient.HTTPRecipient("test");
        JsonObject jsonObject = this.marshaller.marshall((Recipient)recipient);
        Assertions.assertEquals((Object)new JsonObject().put("endpoint", "test").put("classType", Recipient.HTTPRecipient.class.getName()), (Object)jsonObject);
    }

    @Test
    void marshallNull() {
        JsonObject jsonObject = this.marshaller.marshall(null);
        Assertions.assertNull((Object)jsonObject);
    }

    @Test
    void unmarshall() {
        JsonObject jsonObject = new JsonObject().put("endpoint", "test").put("classType", Recipient.HTTPRecipient.class.getName());
        Recipient recipient = this.marshaller.unmarshall(jsonObject);
        Assertions.assertEquals((Object)new Recipient.HTTPRecipient("test"), (Object)recipient);
    }

    @Test
    void unmarshallInvalid() {
        JsonObject jsonObject = new JsonObject().put("endpoint", "test");
        Recipient recipient = this.marshaller.unmarshall(jsonObject);
        Assertions.assertNull((Object)recipient);
    }

    @Test
    void unmarshallNull() {
        Recipient recipient = this.marshaller.unmarshall(null);
        Assertions.assertNull((Object)recipient);
    }
}

