/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql.marshaller;

import io.vertx.core.json.JsonObject;
import java.util.Date;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.jobs.service.repository.postgresql.marshaller.TriggerMarshaller;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

class TriggerMarshallerTest {
    TriggerMarshaller marshaller = new TriggerMarshaller();

    TriggerMarshallerTest() {
    }

    @Test
    void marshallIntervalTrigger() {
        Date startTime = new Date();
        Date endTime = new Date();
        Date nextFireTime = new Date();
        Random random = new Random();
        int repeatLimit = random.nextInt();
        int repeatCount = random.nextInt();
        long period = random.nextLong();
        IntervalTrigger trigger = new IntervalTrigger();
        trigger.setStartTime(startTime);
        trigger.setEndTime(endTime);
        trigger.setRepeatLimit(repeatLimit);
        trigger.setRepeatCount(repeatCount);
        trigger.setNextFireTime(nextFireTime);
        trigger.setPeriod(period);
        JsonObject jsonObject = this.marshaller.marshall((Trigger)trigger);
        Assertions.assertEquals((Object)new JsonObject().put("startTime", Long.valueOf(startTime.getTime())).put("endTime", Long.valueOf(endTime.getTime())).put("nextFireTime", Long.valueOf(nextFireTime.getTime())).put("repeatLimit", Integer.valueOf(repeatLimit)).put("repeatCount", Integer.valueOf(repeatCount)).put("period", Long.valueOf(period)).put("classType", IntervalTrigger.class.getName()), (Object)jsonObject);
    }

    @Test
    void marshallPointInTimeTriggerAccessor() {
        Date time = new Date();
        PointInTimeTrigger trigger = new PointInTimeTrigger(time.getTime(), null, null);
        JsonObject jsonObject = this.marshaller.marshall((Trigger)trigger);
        Assertions.assertEquals((Object)new JsonObject().put("nextFireTime", Long.valueOf(time.getTime())).put("classType", PointInTimeTrigger.class.getName()), (Object)jsonObject);
    }

    @Test
    void marshallNull() {
        JsonObject jsonObject = this.marshaller.marshall(null);
        Assertions.assertNull((Object)jsonObject);
    }

    @Test
    void unmarshallIntervalTrigger() {
        Date startTime = new Date();
        Date endTime = new Date();
        Date nextFireTime = new Date();
        Random random = new Random();
        int repeatLimit = random.nextInt();
        int repeatCount = random.nextInt();
        long period = random.nextLong();
        JsonObject jsonObject = new JsonObject().put("startTime", Long.valueOf(startTime.getTime())).put("endTime", Long.valueOf(endTime.getTime())).put("nextFireTime", Long.valueOf(nextFireTime.getTime())).put("repeatLimit", Integer.valueOf(repeatLimit)).put("repeatCount", Integer.valueOf(repeatCount)).put("period", Long.valueOf(period)).put("classType", IntervalTrigger.class.getName());
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        IntervalTrigger expected = new IntervalTrigger();
        expected.setStartTime(startTime);
        expected.setEndTime(endTime);
        expected.setRepeatLimit(repeatLimit);
        expected.setRepeatCount(repeatCount);
        expected.setNextFireTime(nextFireTime);
        expected.setPeriod(period);
        Assertions.assertEquals((Object)expected.toString(), (Object)trigger.toString());
    }

    @Test
    void unmarshallPointInTimeTriggerAccessor() {
        Date time = new Date();
        JsonObject jsonObject = new JsonObject().put("nextFireTime", Long.valueOf(time.getTime())).put("classType", PointInTimeTrigger.class.getName());
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        Assertions.assertEquals((Object)new PointInTimeTrigger(time.getTime(), null, null).toString(), (Object)trigger.toString());
    }

    @Test
    void unmarshallNull() {
        Trigger trigger = this.marshaller.unmarshall(null);
        Assertions.assertNull((Object)trigger);
    }

    @Test
    void unmarshallInvalid() {
        Date time = new Date();
        JsonObject jsonObject = new JsonObject().put("nextFireTime", Long.valueOf(time.getTime()));
        Trigger trigger = this.marshaller.unmarshall(jsonObject);
        Assertions.assertNull((Object)trigger);
    }
}

