/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.postgresql.marshaller;

import io.vertx.core.json.JsonObject;
import java.util.Date;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

@ApplicationScoped
public class TriggerMarshaller {
    private static final String CLASS_TYPE = "classType";

    public JsonObject marshall(Trigger trigger) {
        if (trigger instanceof IntervalTrigger) {
            return JsonObject.mapFrom((Object)new IntervalTriggerAccessor((IntervalTrigger)trigger)).put(CLASS_TYPE, trigger.getClass().getName());
        }
        if (trigger instanceof PointInTimeTrigger) {
            return JsonObject.mapFrom((Object)new PointInTimeTriggerAccessor((PointInTimeTrigger)trigger)).put(CLASS_TYPE, trigger.getClass().getName());
        }
        return null;
    }

    public Trigger unmarshall(JsonObject jsonObject) {
        String classType = Optional.ofNullable(jsonObject).map(o -> (String)o.remove(CLASS_TYPE)).orElse(null);
        if (IntervalTrigger.class.getName().equals(classType)) {
            return ((IntervalTriggerAccessor)jsonObject.mapTo(IntervalTriggerAccessor.class)).to();
        }
        if (PointInTimeTrigger.class.getName().equals(classType)) {
            return ((PointInTimeTriggerAccessor)jsonObject.mapTo(PointInTimeTriggerAccessor.class)).to();
        }
        return null;
    }

    private static class IntervalTriggerAccessor {
        private Date startTime;
        private Date endTime;
        private int repeatLimit;
        private int repeatCount;
        private Date nextFireTime;
        private long period;

        public IntervalTriggerAccessor() {
        }

        public IntervalTriggerAccessor(IntervalTrigger trigger) {
            this.startTime = trigger.getStartTime();
            this.endTime = trigger.getEndTime();
            this.repeatLimit = trigger.getRepeatLimit();
            this.repeatCount = trigger.getRepeatCount();
            this.nextFireTime = trigger.getNextFireTime();
            this.period = trigger.getPeriod();
        }

        public IntervalTrigger to() {
            IntervalTrigger intervalTrigger = new IntervalTrigger();
            intervalTrigger.setStartTime(this.startTime);
            intervalTrigger.setEndTime(this.endTime);
            intervalTrigger.setRepeatLimit(this.repeatLimit);
            intervalTrigger.setRepeatCount(this.repeatCount);
            intervalTrigger.setNextFireTime(this.nextFireTime);
            intervalTrigger.setPeriod(this.period);
            return intervalTrigger;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public int getRepeatLimit() {
            return this.repeatLimit;
        }

        public void setRepeatLimit(int repeatLimit) {
            this.repeatLimit = repeatLimit;
        }

        public int getRepeatCount() {
            return this.repeatCount;
        }

        public void setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
        }

        public Date getNextFireTime() {
            return this.nextFireTime;
        }

        public void setNextFireTime(Date nextFireTime) {
            this.nextFireTime = nextFireTime;
        }

        public long getPeriod() {
            return this.period;
        }

        public void setPeriod(long period) {
            this.period = period;
        }
    }

    private static class PointInTimeTriggerAccessor {
        private Date nextFireTime;

        public PointInTimeTriggerAccessor() {
        }

        public PointInTimeTriggerAccessor(PointInTimeTrigger trigger) {
            this.nextFireTime = trigger.hasNextFireTime();
        }

        public PointInTimeTrigger to() {
            return Optional.ofNullable(this.nextFireTime).map(Date::getTime).map(t -> new PointInTimeTrigger(t.longValue(), null, null)).orElse(null);
        }

        public Date getNextFireTime() {
            return this.nextFireTime;
        }

        public void setNextFireTime(Date nextFireTime) {
            this.nextFireTime = nextFireTime;
        }
    }
}

