/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.kafka;

import java.util.Collections;
import org.apache.kafka.streams.Topology;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.kafka.KafkaPersistenceUtils;

public class KafkaPersistenceUtilsTest {
    @Test
    public void testTopicName() {
        Assertions.assertThat((String)KafkaPersistenceUtils.topicName((String)"aProcessId")).isEqualTo("kogito.process.aProcessId");
    }

    @Test
    public void testStoreName() {
        Assertions.assertThat((String)KafkaPersistenceUtils.storeName((String)"aProcessId")).isEqualTo("kogito-aProcessId-store");
    }

    @Test
    public void testTopology() {
        Topology topology = KafkaPersistenceUtils.createTopologyForProcesses(Collections.emptyList());
        Assertions.assertThat((Iterable)topology.describe().globalStores()).isEmpty();
        topology = KafkaPersistenceUtils.createTopologyForProcesses(Collections.singletonList("aProcess"));
        Assertions.assertThat((Iterable)topology.describe().globalStores()).hasSize(1);
    }
}

