/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.infinispan.protostream.BaseMarshaller;
import org.kie.kogito.persistence.kafka.KafkaProcessInstances;
import org.kie.kogito.persistence.kafka.KafkaStreamsStateListener;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KogitoProcessInstancesFactory
implements ProcessInstancesFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoProcessInstancesFactory.class);
    KafkaStreamsStateListener stateListener;
    KafkaProducer<String, byte[]> producer;

    @Inject
    public void setStateListener(KafkaStreamsStateListener stateListener) {
        this.stateListener = stateListener;
    }

    @Inject
    @Named(value="default-kafka-broker")
    public void setKafkaConfig(Map<String, Object> kafkaConfig) {
        this.producer = new KafkaProducer(kafkaConfig, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
    }

    @PreDestroy
    public void stop() {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public KafkaProcessInstances createProcessInstances(Process<?> process) {
        try {
            LOGGER.info("Creating KafkaProcessInstances for process: {}", (Object)process.id());
            KafkaProcessInstances pi = new KafkaProcessInstances(process, this.producer, this.proto(), this.marshallers().toArray(new BaseMarshaller[0]));
            this.stateListener.addProcessInstances(pi);
            return pi;
        }
        catch (Exception ex) {
            LOGGER.error("Error creating KafkaProcessInstances for process: {}", (Object)process.id(), (Object)ex);
            throw new RuntimeException("Error creating KafkaProcessInstances for process: " + process.id(), ex);
        }
    }

    public String proto() {
        return null;
    }

    public List<BaseMarshaller> marshallers() {
        return Collections.emptyList();
    }
}

