/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.TimeZone;
import java.util.UUID;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.events.knative.ce.CloudEventConverter;
import org.kie.kogito.services.event.AbstractProcessDataEvent;

class CloudEventConverterTest {
    CloudEventConverterTest() {
    }

    @Test
    void verifyBasicCloudEventConversion() {
        String eventId = UUID.randomUUID().toString();
        URI src = URI.create("/trigger");
        String eventType = "My.Cloud.Event.Type";
        String payload = "Oi Mundo!";
        CloudEvent cloudEvent = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withType("My.Cloud.Event.Type").withId(eventId).withSource(src).withData("Oi Mundo!".getBytes())).build();
        String ceJson = CloudEventConverter.toJson((CloudEvent)cloudEvent);
        ((AbstractStringAssert)Assertions.assertThat((String)ceJson).isNotEmpty()).contains(new CharSequence[]{"Oi Mundo!"});
    }

    @Test
    void verifyDataEventCloudEventConversion() throws IOException {
        ObjectMapper json = new ObjectMapper();
        json.setDateFormat((DateFormat)new StdDateFormat().withColonInTimeZone(true).withTimeZone(TimeZone.getDefault()));
        String messageJson = "{\n  \"specversion\": \"0.3\",\n  \"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\n  \"source\": \"/process/instance/12345\",\n  \"type\": \"process.persons.travellers\",\n  \"time\": \"2019-10-01T12:02:23.812262+02:00\",\n  \"data\": {\n\t\"firstName\" : \"Jan\",\n\t\"lastName\" : \"Kowalski\",\n\t\"email\" : \"jan.kowalski@example.com\",\n\t\"nationality\" : \"Polish\"\n\t}\n}";
        PersonDataEvent dataEventJson = (PersonDataEvent)((Object)json.readValue("{\n  \"specversion\": \"0.3\",\n  \"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\n  \"source\": \"/process/instance/12345\",\n  \"type\": \"process.persons.travellers\",\n  \"time\": \"2019-10-01T12:02:23.812262+02:00\",\n  \"data\": {\n\t\"firstName\" : \"Jan\",\n\t\"lastName\" : \"Kowalski\",\n\t\"email\" : \"jan.kowalski@example.com\",\n\t\"nationality\" : \"Polish\"\n\t}\n}", PersonDataEvent.class));
        Assertions.assertThat((String)((Person)dataEventJson.getData()).getEmail()).isEqualTo("jan.kowalski@example.com");
        Assertions.assertThat((Object)((Object)dataEventJson)).isNotNull();
        CloudEvent event = CloudEventConverter.toCloudEvent((byte[])"{\n  \"specversion\": \"0.3\",\n  \"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\n  \"source\": \"/process/instance/12345\",\n  \"type\": \"process.persons.travellers\",\n  \"time\": \"2019-10-01T12:02:23.812262+02:00\",\n  \"data\": {\n\t\"firstName\" : \"Jan\",\n\t\"lastName\" : \"Kowalski\",\n\t\"email\" : \"jan.kowalski@example.com\",\n\t\"nationality\" : \"Polish\"\n\t}\n}".getBytes());
        Assertions.assertThat((Object)event).isNotNull();
        Person person = (Person)json.readValue(event.getData(), Person.class);
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((String)person.getEmail()).isEqualTo("jan.kowalski@example.com");
        String convertedEvent = CloudEventConverter.toJson((CloudEvent)event);
        Assertions.assertThat((String)convertedEvent).contains(new CharSequence[]{"jan.kowalski@example.com"});
    }

    @Test
    void verifyDataEventWithProcessDataCloudEventConversion() {
        String messageJson = "{\n  \"kogitoReferenceId\": \"12345\",\n  \"specversion\": \"0.3\",\n  \"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\n  \"source\": \"/process/instance/12345\",\n  \"type\": \"process.persons.travellers\",\n  \"time\": \"2019-10-01T12:02:23.812262+02:00\",\n  \"data\": {\n\t\"firstName\" : \"Jan\",\n\t\"lastName\" : \"Kowalski\",\n\t\"email\" : \"jan.kowalski@example.com\",\n\t\"nationality\" : \"Polish\"\n\t}\n}";
        CloudEvent event = CloudEventConverter.toCloudEvent((byte[])"{\n  \"kogitoReferenceId\": \"12345\",\n  \"specversion\": \"0.3\",\n  \"id\": \"21627e26-31eb-43e7-8343-92a696fd96b1\",\n  \"source\": \"/process/instance/12345\",\n  \"type\": \"process.persons.travellers\",\n  \"time\": \"2019-10-01T12:02:23.812262+02:00\",\n  \"data\": {\n\t\"firstName\" : \"Jan\",\n\t\"lastName\" : \"Kowalski\",\n\t\"email\" : \"jan.kowalski@example.com\",\n\t\"nationality\" : \"Polish\"\n\t}\n}".getBytes());
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((Iterable)event.getExtensionNames()).isNotEmpty();
        String convertedEvent = CloudEventConverter.toJson((CloudEvent)event);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)convertedEvent).contains(new CharSequence[]{"jan.kowalski@example.com"})).contains(new CharSequence[]{"kogitoReferenceId"})).contains(new CharSequence[]{"12345"});
    }

    public static class Person {
        private String firstName;
        private String lastName;
        private String email;
        private String nationality;

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getNationality() {
            return this.nationality;
        }

        public void setNationality(String nationality) {
            this.nationality = nationality;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }

    public static class PersonDataEvent
    extends AbstractProcessDataEvent<Person> {
        private String kogitoStartFromNode;

        public PersonDataEvent(String source, Person body, String kogitoProcessinstanceId, String kogitoParentProcessinstanceId, String kogitoRootProcessinstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoProcessinstanceState, String kogitoAddons) {
            super(source, (Object)body, kogitoProcessinstanceId, kogitoParentProcessinstanceId, kogitoRootProcessinstanceId, kogitoProcessId, kogitoRootProcessId, kogitoProcessinstanceState, kogitoAddons);
        }

        public PersonDataEvent() {
            super(null, null, null, null, null, null, null, null, null);
        }

        public String getKogitoStartFromNode() {
            return this.kogitoStartFromNode;
        }

        public void setKogitoStartFromNode(String kogitoStartFromNode) {
            this.kogitoStartFromNode = kogitoStartFromNode;
        }
    }
}

