/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.http;

import io.cloudevents.CloudEvent;
import io.cloudevents.http.restful.ws.impl.RestfulWSMessageFactory;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.spi.HttpRequest;
import org.kie.kogito.events.knative.ce.http.AbstractHttpRequestConverter;
import org.kie.kogito.events.knative.ce.http.HttpRequestConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestEasyHttpRequestConverter
extends AbstractHttpRequestConverter
implements HttpRequestConverter<HttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestEasyHttpRequestConverter.class);

    @Override
    public CloudEvent from(HttpRequest request) {
        try {
            LOGGER.debug("About to convert an HttpRequest into CloudEvent");
            String payload = this.inputStreamToString(request.getInputStream());
            LOGGER.debug("HttpRequest payload to be converted into CloudEvent: \n{}", (Object)payload);
            return RestfulWSMessageFactory.create((MediaType)request.getHttpHeaders().getMediaType(), (MultivaluedMap)request.getHttpHeaders().getRequestHeaders(), (byte[])payload.getBytes()).toEvent();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Failed to parse CloudEvent. For more detailed payload information, turn DEBUG on: '%s'", ex.getMessage()), ex);
        }
    }
}

