/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.extensions;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.events.knative.ce.extensions.KogitoProcessExtension;

class KogitoProcessExtensionTest {
    KogitoProcessExtensionTest() {
    }

    @BeforeAll
    static void setupTest() {
        ExtensionProvider.getInstance().registerExtension(KogitoProcessExtension.class, KogitoProcessExtension::new);
    }

    @Test
    void verifyKogitoExtensionCanBeRead() {
        KogitoProcessExtension kpe = new KogitoProcessExtension();
        kpe.readFrom((CloudEventExtensions)this.getExampleCloudEvent());
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)kpe.getValue("kogitoreferenceid")).isNotNull()).isInstanceOf(String.class)).isEqualTo((Object)"12345");
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)kpe.getValue("kogitoprocessid")).isNotNull()).isInstanceOf(String.class)).isEqualTo((Object)"super_process");
        Assertions.assertThat((String)((String)kpe.getValue(KogitoProcessExtension.PROCESS_INSTANCE_ID))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue(KogitoProcessExtension.PROCESS_INSTANCE_STATE))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue(KogitoProcessExtension.ROOT_PROCESS_INSTANCE_ID))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue(KogitoProcessExtension.ROOT_PROCESS_ID))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitoparentprocessinstanceid"))).isBlank();
        Assertions.assertThat((String)((String)kpe.getValue("kogitoaddons"))).isBlank();
    }

    @Test
    void verifyKeysAreSet() {
        KogitoProcessExtension kpe = (KogitoProcessExtension)ExtensionProvider.getInstance().parseExtension(KogitoProcessExtension.class, (CloudEventExtensions)this.getExampleCloudEvent());
        Assertions.assertThat((Iterable)kpe.getKeys()).isNotEmpty();
    }

    private CloudEvent getExampleCloudEvent() {
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withType("example.demo").withSource(URI.create("http://example.com")).withData("application/json", "{}".getBytes())).withExtension("kogitoreferenceid", "12345")).withExtension("kogitoprocessid", "super_process")).build();
    }
}

