/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.knative.ce.http;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class CloudEventListenerResourceTest {
    CloudEventListenerResourceTest() {
    }

    @Test
    void verifyHttpRequestUnsupportedMediaType() {
        ((ValidatableResponse)((Response)RestAssured.given().when().header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"text/plain", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsString() {
        String source = "/from/unit/test";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.equalTo((Object)"{ \"message\": \"Hola Mundo!\" }"), new Matcher[0])).header("ce-kogitoreferenceid", "12345");
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsPOJO() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        Message msg = (Message)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoReferenceId", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.equalTo((Object)"{ \"message\": \"Hola Mundo!\" }"), new Matcher[0])).header("ce-source", "/from/unit/test")).extract().as(Message.class);
        Assertions.assertThat((String)msg.getMessage()).isEqualTo("Hola Mundo!");
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsPOJO() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        Message msg = (Message)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"kogitoReferenceId\":\"12345!\", \"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType(MediaType.valueOf((String)"application/cloudevents+json").withCharset(StandardCharsets.UTF_8.name()).toString()).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).header("ce-source", "/from/unit/test")).header("ce-kogitoReferenceId", "12345!")).extract().body().as(Message.class);
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsString() throws URISyntaxException, IOException {
        String source = "/from/unit/test";
        Message msg = (Message)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType("application/cloudevents+json").post("", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).header("ce-source", "/from/unit/test")).extract().body().as(Message.class);
        Assertions.assertThat((Object)msg).isNotNull();
        Assertions.assertThat((String)msg.getMessage()).isEqualTo("Hi World!");
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    public static class Message {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

