/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb.codec;

import com.mongodb.MongoClientSettings;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.kie.kogito.event.AbstractDataEvent;

public class CodecUtils {
    static final String ID = "_id";
    private static final Codec<Document> CODEC = new DocumentCodec(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})}));

    private CodecUtils() {
    }

    static void encodeDataEvent(Document doc, AbstractDataEvent<?> event) {
        doc.put(ID, (Object)event.getId());
        doc.put("specVersion", (Object)event.getSpecVersion());
        doc.put("source", (Object)event.getSource());
        doc.put("type", (Object)event.getType());
        doc.put("time", (Object)event.getTime());
        doc.put("subject", (Object)event.getSubject());
        doc.put("dataContentType", (Object)event.getDataContentType());
        doc.put("dataSchema", (Object)event.getDataSchema());
        doc.put("kogitoProcessinstanceId", (Object)event.getKogitoProcessinstanceId());
        doc.put("kogitoRootProcessinstanceId", (Object)event.getKogitoRootProcessinstanceId());
        doc.put("kogitoProcessId", (Object)event.getKogitoProcessId());
        doc.put("kogitoRootProcessId", (Object)event.getKogitoRootProcessId());
        doc.put("kogitoAddons", (Object)event.getKogitoAddons());
    }

    static Codec<Document> codec() {
        return CODEC;
    }
}

